/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.login;

import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Callable;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.ParametricPrivilegedExceptionAction;
import org.wildfly.security.auth.login.SecurityDomain;
import org.wildfly.security.auth.spi.AuthenticatedRealmIdentity;

public final class SecurityIdentity {
    private final SecurityDomain securityDomain;
    private final AuthenticatedRealmIdentity authenticatedRealmIdentity;

    SecurityIdentity(SecurityDomain securityDomain, AuthenticatedRealmIdentity authenticatedRealmIdentity) {
        this.securityDomain = securityDomain;
        this.authenticatedRealmIdentity = authenticatedRealmIdentity;
    }

    SecurityDomain getSecurityDomain() {
        return this.securityDomain;
    }

    AuthenticatedRealmIdentity getAuthenticatedRealmIdentity() {
        return this.authenticatedRealmIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAs(Runnable action) {
        if (action == null) {
            return;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            action.run();
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runAs(Callable<T> action) throws Exception {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = action.call();
            return t;
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runAs(PrivilegedAction<T> action) {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = action.run();
            return t;
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    public <T> T runAs(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = action.run();
            return t;
        }
        catch (RuntimeException | PrivilegedActionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, P> T runAs(P parameter, ParametricPrivilegedAction<T, P> action) {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = action.run(parameter);
            return t;
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    public <T, P> T runAs(P parameter, ParametricPrivilegedExceptionAction<T, P> action) throws PrivilegedActionException {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = action.run(parameter);
            return t;
        }
        catch (RuntimeException | PrivilegedActionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }
}

