/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider.ldap;

import java.nio.charset.Charset;
import java.security.spec.InvalidKeySpecException;
import org.wildfly.security.password.spec.BSDUnixDESCryptPasswordSpec;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.PasswordSpec;
import org.wildfly.security.password.spec.SaltedSimpleDigestPasswordSpec;
import org.wildfly.security.password.spec.SimpleDigestPasswordSpec;
import org.wildfly.security.password.spec.UnixDESCryptPasswordSpec;
import org.wildfly.security.util.Alphabet;
import org.wildfly.security.util.CodePointIterator;

class UserPasswordPasswordUtil {
    static final Charset UTF_8 = Charset.forName("UTF-8");

    private UserPasswordPasswordUtil() {
    }

    public static PasswordSpec parseUserPassword(byte[] userPassword) throws InvalidKeySpecException {
        if (userPassword == null || userPassword.length == 0) {
            throw new IllegalArgumentException("userPassword can not be null or empty.");
        }
        if (userPassword[0] != 123) {
            return UserPasswordPasswordUtil.createClearPasswordSpec(userPassword);
        }
        if (userPassword[1] == 109 && userPassword[2] == 100 && userPassword[3] == 53 && userPassword[4] == 125) {
            return UserPasswordPasswordUtil.createSimpleDigestPasswordSpec("simple-digest-md5", 5, userPassword);
        }
        if (userPassword[1] == 115 && userPassword[2] == 104 && userPassword[3] == 97) {
            if (userPassword[4] == 125) {
                return UserPasswordPasswordUtil.createSimpleDigestPasswordSpec("simple-digest-sha-1", 5, userPassword);
            }
            if (userPassword[4] == 50 && userPassword[5] == 53 && userPassword[6] == 54 && userPassword[7] == 125) {
                return UserPasswordPasswordUtil.createSimpleDigestPasswordSpec("simple-digest-sha-256", 8, userPassword);
            }
            if (userPassword[4] == 51 && userPassword[5] == 56 && userPassword[6] == 52 && userPassword[7] == 125) {
                return UserPasswordPasswordUtil.createSimpleDigestPasswordSpec("simple-digest-sha-384", 8, userPassword);
            }
            if (userPassword[4] == 53 && userPassword[5] == 49 && userPassword[6] == 50 && userPassword[7] == 125) {
                return UserPasswordPasswordUtil.createSimpleDigestPasswordSpec("simpledigest-sha-512", 8, userPassword);
            }
        } else {
            if (userPassword[1] == 115 && userPassword[2] == 109 && userPassword[3] == 100 && userPassword[4] == 53 && userPassword[5] == 125) {
                return UserPasswordPasswordUtil.createSaltedSimpleDigestPasswordSpec("password-salt-digest-md5", 6, userPassword);
            }
            if (userPassword[1] == 115 && userPassword[2] == 115 && userPassword[3] == 104 && userPassword[4] == 97) {
                if (userPassword[5] == 125) {
                    return UserPasswordPasswordUtil.createSaltedSimpleDigestPasswordSpec("password-salt-digest-sha-1", 6, userPassword);
                }
                if (userPassword[5] == 50 && userPassword[6] == 53 && userPassword[7] == 54 && userPassword[8] == 125) {
                    return UserPasswordPasswordUtil.createSaltedSimpleDigestPasswordSpec("password-salt-digest-sha-256", 9, userPassword);
                }
                if (userPassword[5] == 51 && userPassword[6] == 56 && userPassword[7] == 52 && userPassword[8] == 125) {
                    return UserPasswordPasswordUtil.createSaltedSimpleDigestPasswordSpec("password-salt-digest-sha-384", 9, userPassword);
                }
                if (userPassword[5] == 53 && userPassword[6] == 49 && userPassword[7] == 50 && userPassword[8] == 125) {
                    return UserPasswordPasswordUtil.createSaltedSimpleDigestPasswordSpec("password-salt-digest-sha-512", 9, userPassword);
                }
            } else if (userPassword[1] == 99 && userPassword[2] == 114 && userPassword[3] == 121 && userPassword[4] == 112 && userPassword[5] == 116 && userPassword[6] == 125) {
                if (userPassword[7] == 95) {
                    return UserPasswordPasswordUtil.createBsdCryptBasedSpec(userPassword);
                }
                return UserPasswordPasswordUtil.createCryptBasedSpec(userPassword);
            }
        }
        for (int i = 1; i < userPassword.length - 1; ++i) {
            if (userPassword[i] != 125) continue;
            throw new InvalidKeySpecException();
        }
        return UserPasswordPasswordUtil.createClearPasswordSpec(userPassword);
    }

    private static PasswordSpec createClearPasswordSpec(byte[] userPassword) {
        return new ClearPasswordSpec(new String(userPassword, UTF_8).toCharArray());
    }

    private static PasswordSpec createSimpleDigestPasswordSpec(String algorithm, int prefixSize, byte[] userPassword) throws InvalidKeySpecException {
        int length = userPassword.length - prefixSize;
        byte[] digest = CodePointIterator.ofUtf8Bytes(userPassword, prefixSize, length).base64Decode().drain();
        return new SimpleDigestPasswordSpec(algorithm, digest);
    }

    private static PasswordSpec createSaltedSimpleDigestPasswordSpec(String algorithm, int prefixSize, byte[] userPassword) throws InvalidKeySpecException {
        int digestLength;
        int length = userPassword.length - prefixSize;
        byte[] decoded = CodePointIterator.ofUtf8Bytes(userPassword, prefixSize, length).base64Decode().drain();
        int saltLength = decoded.length - (digestLength = UserPasswordPasswordUtil.expectedDigestLengthBytes(algorithm));
        if (saltLength < 1) {
            throw new InvalidKeySpecException("Insufficient data to form a digest and a salt.");
        }
        byte[] digest = new byte[digestLength];
        byte[] salt = new byte[saltLength];
        System.arraycopy(decoded, 0, digest, 0, digestLength);
        System.arraycopy(decoded, digestLength, salt, 0, saltLength);
        return new SaltedSimpleDigestPasswordSpec(algorithm, digest, salt);
    }

    private static PasswordSpec createCryptBasedSpec(byte[] userPassword) throws InvalidKeySpecException {
        if (userPassword.length != 20) {
            throw new InvalidKeySpecException("Insufficient data to form a digest and a salt.");
        }
        int lo = Alphabet.Base64Alphabet.MOD_CRYPT.decode(userPassword[7] & 0xFF);
        int hi = Alphabet.Base64Alphabet.MOD_CRYPT.decode(userPassword[8] & 0xFF);
        if (lo == -1 || hi == -1) {
            throw new IllegalArgumentException(String.format("Invalid salt (%s%s)", Character.valueOf((char)lo), Character.valueOf((char)hi)));
        }
        short salt = (short)(lo | hi << 6);
        byte[] hash = CodePointIterator.ofUtf8Bytes(userPassword, 9, 11).base64Decode(Alphabet.Base64Alphabet.MOD_CRYPT, false).drain();
        return new UnixDESCryptPasswordSpec(hash, salt);
    }

    private static PasswordSpec createBsdCryptBasedSpec(byte[] userPassword) throws InvalidKeySpecException {
        if (userPassword.length != 27) {
            throw new InvalidKeySpecException("Insufficient data to form a digest and a salt.");
        }
        int b0 = Alphabet.Base64Alphabet.MOD_CRYPT.decode(userPassword[8] & 0xFF);
        int b1 = Alphabet.Base64Alphabet.MOD_CRYPT.decode(userPassword[9] & 0xFF);
        int b2 = Alphabet.Base64Alphabet.MOD_CRYPT.decode(userPassword[10] & 0xFF);
        int b3 = Alphabet.Base64Alphabet.MOD_CRYPT.decode(userPassword[11] & 0xFF);
        if (b0 == -1 || b1 == -1 || b2 == -1 || b3 == -1) {
            throw new IllegalArgumentException(String.format("Invalid rounds (%s%s%s%s)", Character.valueOf((char)b0), Character.valueOf((char)b1), Character.valueOf((char)b2), Character.valueOf((char)b3)));
        }
        int iterationCount = b0 | b1 << 6 | b2 << 12 | b3 << 18;
        b0 = Alphabet.Base64Alphabet.MOD_CRYPT.decode(userPassword[12] & 0xFF);
        b1 = Alphabet.Base64Alphabet.MOD_CRYPT.decode(userPassword[13] & 0xFF);
        b2 = Alphabet.Base64Alphabet.MOD_CRYPT.decode(userPassword[14] & 0xFF);
        b3 = Alphabet.Base64Alphabet.MOD_CRYPT.decode(userPassword[15] & 0xFF);
        if (b0 == -1 || b1 == -1 || b2 == -1 || b3 == -1) {
            throw new IllegalArgumentException(String.format("Invalid salt (%s%s%s%s)", Character.valueOf((char)b0), Character.valueOf((char)b1), Character.valueOf((char)b2), Character.valueOf((char)b3)));
        }
        int salt = b0 | b1 << 6 | b2 << 12 | b3 << 18;
        byte[] hash = CodePointIterator.ofUtf8Bytes(userPassword, 16, 11).base64Decode(Alphabet.Base64Alphabet.MOD_CRYPT, false).drain();
        return new BSDUnixDESCryptPasswordSpec(hash, salt, iterationCount);
    }

    private static int expectedDigestLengthBytes(String algorithm) {
        switch (algorithm) {
            case "password-salt-digest-md5": {
                return 16;
            }
            case "password-salt-digest-sha-1": {
                return 20;
            }
            case "password-salt-digest-sha-256": {
                return 32;
            }
            case "password-salt-digest-sha-384": {
                return 48;
            }
            case "password-salt-digest-sha-512": {
                return 64;
            }
        }
        throw new IllegalArgumentException("Unrecognised algorithm.");
    }
}

