/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.digest;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import org.wildfly.security.sasl.digest._private.DigestUtil;
import org.wildfly.security.sasl.util.AbstractSaslParticipant;
import org.wildfly.security.sasl.util.SaslWrapper;
import org.wildfly.security.util.ByteIterator;
import org.wildfly.security.util.ByteStringBuilder;
import org.wildfly.security.util.DefaultTransformationMapper;
import org.wildfly.security.util.TransformationSpec;
import org.wildfly.security.util._private.Arrays2;

abstract class AbstractDigestMechanism
extends AbstractSaslParticipant {
    private static final int MAX_PARSED_RESPONSE_SIZE = 13;
    private static int NONCE_SIZE = 36;
    public static final int DEFAULT_MAXBUF = 65536;
    public static final char DELIMITER = ',';
    public static final String[] CIPHER_OPTS = new String[]{"des", "3des", "rc4", "rc4-40", "rc4-56"};
    private FORMAT format;
    protected String digestURI;
    private Charset charset = StandardCharsets.ISO_8859_1;
    protected MessageDigest md5;
    protected String cipher;
    protected String qop;
    protected int wrapSeqNum;
    protected int unwrapSeqNum;
    protected byte[] nonce;
    protected byte[] cnonce;
    protected String authzid;
    protected byte[] hA1;
    protected SecureRandom secureRandomGenerator = new SecureRandom();
    protected Mac hmacMD5 = this.getHmac();
    protected Cipher wrapCipher = null;
    protected Cipher unwrapCipher = null;
    protected byte[] wrapHmacKeyIntegrity;
    protected byte[] unwrapHmacKeyIntegrity;
    private static final String CLIENT_MAGIC_INTEGRITY = "Digest session key to client-to-server signing key magic constant";
    private static final String SERVER_MAGIC_INTEGRITY = "Digest session key to server-to-client signing key magic constant";
    private static final String CLIENT_MAGIC_CONFIDENTIALITY = "Digest H(A1) to client-to-server sealing key magic constant";
    private static final String SERVER_MAGIC_CONFIDENTIALITY = "Digest H(A1) to server-to-client sealing key magic constant";

    public AbstractDigestMechanism(String mechanismName, String protocol, String serverName, CallbackHandler callbackHandler, FORMAT format, Charset charset, String[] ciphers) throws SaslException {
        super(mechanismName, protocol, serverName, callbackHandler);
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SaslException("Algorithm not supported", e);
        }
        this.format = format;
        this.digestURI = this.getProtocol() + "/" + this.getServerName();
        this.charset = charset != null ? charset : StandardCharsets.ISO_8859_1;
    }

    protected static int skipWhiteSpace(byte[] buffer, int startPoint) {
        int i;
        for (i = startPoint; i < buffer.length && AbstractDigestMechanism.isWhiteSpace(buffer[i]); ++i) {
        }
        return i;
    }

    protected static boolean isWhiteSpace(byte b) {
        if (b == 13) {
            return true;
        }
        if (b == 10) {
            return true;
        }
        if (b == 9) {
            return true;
        }
        return b == 32;
    }

    static String getSupportedCiphers(String[] demandedCiphers) {
        DefaultTransformationMapper trans = new DefaultTransformationMapper();
        if (demandedCiphers == null) {
            demandedCiphers = CIPHER_OPTS;
        }
        StringBuilder ciphers = new StringBuilder();
        for (TransformationSpec ts : trans.getTransformationSpecByStrength("DIGEST-MD5", demandedCiphers)) {
            if (ciphers.length() > 0) {
                ciphers.append(',');
            }
            ciphers.append(ts.getToken());
        }
        return ciphers.toString();
    }

    static byte[] generateNonce() {
        SecureRandom random = new SecureRandom();
        byte[] nonceData = new byte[NONCE_SIZE];
        random.nextBytes(nonceData);
        return ByteIterator.ofBytes(nonceData).base64Encode().drainToString().getBytes(StandardCharsets.US_ASCII);
    }

    HashMap<String, byte[]> parseResponse(byte[] challenge) throws SaslException {
        HashMap<String, byte[]> response = new HashMap<String, byte[]>(13);
        int i = AbstractDigestMechanism.skipWhiteSpace(challenge, 0);
        StringBuilder key = new StringBuilder(10);
        ByteStringBuilder value = new ByteStringBuilder();
        Integer realmNumber = new Integer(0);
        boolean insideKey = true;
        boolean insideQuotedValue = false;
        boolean expectSeparator = false;
        while (i < challenge.length) {
            byte b = challenge[i];
            if (insideKey) {
                if (b == 44) {
                    throw new SaslException("DIGEST-MD5 keyword cannot contain ',' " + key.toString());
                }
                if (b == 61) {
                    if (key.length() == 0) {
                        throw new SaslException("DIGEST-MD5 keyword cannot be empty");
                    }
                    insideKey = false;
                    if ((i = AbstractDigestMechanism.skipWhiteSpace(challenge, i + 1)) < challenge.length) {
                        if (challenge[i] != 34) continue;
                        insideQuotedValue = true;
                        ++i;
                        continue;
                    }
                    throw new SaslException("No value found for keyword: " + key.toString());
                }
                if (AbstractDigestMechanism.isWhiteSpace(b)) {
                    if ((i = AbstractDigestMechanism.skipWhiteSpace(challenge, i + 1)) < challenge.length) {
                        if (challenge[i] == 61) continue;
                        throw new SaslException("'=' expected after keyword: " + key.toString());
                    }
                    throw new SaslException("'=' expected after keyword: " + key.toString());
                }
                key.append((char)(b & 0xFF));
                ++i;
                continue;
            }
            if (insideQuotedValue) {
                if (b == 92) {
                    if (++i < challenge.length) {
                        value.append(challenge[i]);
                        ++i;
                        continue;
                    }
                    throw new SaslException("Unmatched quote found for value: " + value.toString());
                }
                if (b == 34) {
                    ++i;
                    insideQuotedValue = false;
                    expectSeparator = true;
                    continue;
                }
                value.append(b);
                ++i;
                continue;
            }
            if (AbstractDigestMechanism.isWhiteSpace(b) || b == 44) {
                realmNumber = this.addToParsedChallenge(response, key, value, realmNumber);
                key = new StringBuilder();
                value = new ByteStringBuilder();
                if ((i = AbstractDigestMechanism.skipWhiteSpace(challenge, i)) >= challenge.length || challenge[i] != 44) continue;
                expectSeparator = false;
                insideKey = true;
                ++i;
                continue;
            }
            if (expectSeparator) {
                String val = new String(value.toArray(), this.charset);
                throw new SaslException("Expecting comma or linear whitespace after quoted string: \"" + val + "\"");
            }
            value.append(b);
            ++i;
        }
        if (insideQuotedValue) {
            throw new SaslException("Unmatched quote found for value: " + value.toString());
        }
        if (key.length() > 0) {
            realmNumber = this.addToParsedChallenge(response, key, value, realmNumber);
        }
        return response;
    }

    private int addToParsedChallenge(HashMap<String, byte[]> response, StringBuilder keyBuilder, ByteStringBuilder valueBuilder, int realmNumber) {
        String k = keyBuilder.toString();
        byte[] v = valueBuilder.toArray();
        if (this.format == FORMAT.CLIENT && "realm".equals(k)) {
            response.put(k + ":" + String.valueOf(realmNumber), v);
            ++realmNumber;
        } else {
            response.put(k, v);
        }
        return realmNumber;
    }

    protected boolean arrayContains(String[] array, String searched) {
        for (String item : array) {
            if (!searched.equals(item)) continue;
            return true;
        }
        return false;
    }

    public Charset getCharset() {
        return this.charset;
    }

    private byte[] wrapIntegrityProtectedMessage(byte[] message, int offset, int len) throws SaslException {
        byte[] messageMac = DigestUtil.computeHMAC(this.wrapHmacKeyIntegrity, this.wrapSeqNum, this.hmacMD5, message, offset, len);
        byte[] result = new byte[len + 16];
        System.arraycopy(message, offset, result, 0, len);
        System.arraycopy(messageMac, 0, result, len, 10);
        DigestUtil.integerByteOrdered(1, result, len + 10, 2);
        DigestUtil.integerByteOrdered(this.wrapSeqNum, result, len + 12, 4);
        ++this.wrapSeqNum;
        return result;
    }

    private byte[] unwrapIntegrityProtectedMessage(byte[] message, int offset, int len) throws SaslException {
        int messageType = DigestUtil.decodeByteOrderedInteger(message, offset + len - 6, 2);
        int extractedSeqNum = DigestUtil.decodeByteOrderedInteger(message, offset + len - 4, 4);
        if (messageType != 1) {
            throw new SaslException("MessageType must equal to 1, but is different");
        }
        if (extractedSeqNum != this.unwrapSeqNum) {
            throw new SaslException("Bad sequence number while unwrapping");
        }
        byte[] extractedMessageMac = new byte[10];
        byte[] extractedMessage = new byte[len - 16];
        System.arraycopy(message, offset, extractedMessage, 0, len - 16);
        System.arraycopy(message, offset + len - 16, extractedMessageMac, 0, 10);
        byte[] expectedHmac = DigestUtil.computeHMAC(this.unwrapHmacKeyIntegrity, extractedSeqNum, this.hmacMD5, extractedMessage, 0, extractedMessage.length);
        if (!Arrays2.equals(expectedHmac, 0, extractedMessageMac, 0, 10)) {
            return NO_BYTES;
        }
        ++this.unwrapSeqNum;
        return extractedMessage;
    }

    private byte[] wrapConfidentialityProtectedMessage(byte[] message, int offset, int len) throws SaslException {
        byte[] messageMac = DigestUtil.computeHMAC(this.wrapHmacKeyIntegrity, this.wrapSeqNum, this.hmacMD5, message, offset, len);
        int paddingLength = 0;
        byte[] pad = null;
        int blockSize = this.wrapCipher.getBlockSize();
        if (blockSize > 0) {
            paddingLength = blockSize - (len + 10) % blockSize;
            pad = new byte[paddingLength];
            Arrays.fill(pad, (byte)paddingLength);
        }
        byte[] toCipher = new byte[len + paddingLength + 10];
        System.arraycopy(message, offset, toCipher, 0, len);
        if (paddingLength > 0) {
            System.arraycopy(pad, 0, toCipher, len, paddingLength);
        }
        System.arraycopy(messageMac, 0, toCipher, len + paddingLength, 10);
        byte[] cipheredPart = null;
        try {
            cipheredPart = this.wrapCipher.update(toCipher);
        }
        catch (Exception e) {
            throw new SaslException("Problem during crypt.", e);
        }
        byte[] result = new byte[cipheredPart.length + 6];
        System.arraycopy(cipheredPart, 0, result, 0, cipheredPart.length);
        DigestUtil.integerByteOrdered(1, result, cipheredPart.length, 2);
        DigestUtil.integerByteOrdered(this.wrapSeqNum, result, cipheredPart.length + 2, 4);
        ++this.wrapSeqNum;
        return result;
    }

    private byte[] unwrapConfidentialityProtectedMessage(byte[] message, int offset, int len) throws SaslException {
        int messageType = DigestUtil.decodeByteOrderedInteger(message, offset + len - 6, 2);
        int extractedSeqNum = DigestUtil.decodeByteOrderedInteger(message, offset + len - 4, 4);
        if (messageType != 1) {
            throw new SaslException("MessageType must equal to 1, but is different");
        }
        if (extractedSeqNum != this.unwrapSeqNum) {
            throw new SaslException("Bad sequence number while unwrapping");
        }
        byte[] clearText = null;
        try {
            clearText = this.unwrapCipher.update(message, offset, len - 6);
        }
        catch (Exception e) {
            throw new SaslException("Problem during decrypt.", e);
        }
        byte[] hmac = new byte[10];
        System.arraycopy(clearText, clearText.length - 10, hmac, 0, 10);
        byte[] decryptedMessage = null;
        if (this.unwrapCipher.getBlockSize() > 0) {
            byte padSize = clearText[clearText.length - 10 - 1];
            int decryptedMessageSize = clearText.length - 10;
            if (padSize < 8) {
                int i = clearText.length - 10 - 1;
                while (clearText[i] == padSize) {
                    --i;
                }
                decryptedMessageSize = i + 1;
            }
            decryptedMessage = new byte[decryptedMessageSize];
            System.arraycopy(clearText, 0, decryptedMessage, 0, decryptedMessageSize);
        } else {
            decryptedMessage = new byte[clearText.length - 10];
            System.arraycopy(clearText, 0, decryptedMessage, 0, clearText.length - 10);
        }
        byte[] expectedHmac = DigestUtil.computeHMAC(this.unwrapHmacKeyIntegrity, extractedSeqNum, this.hmacMD5, decryptedMessage, 0, decryptedMessage.length);
        if (!Arrays2.equals(expectedHmac, 0, hmac, 0, 10)) {
            return NO_BYTES;
        }
        ++this.unwrapSeqNum;
        return decryptedMessage;
    }

    protected void createCiphersAndKeys() throws SaslException {
        this.wrapHmacKeyIntegrity = this.createIntegrityKey(true);
        this.unwrapHmacKeyIntegrity = this.createIntegrityKey(false);
        if (this.cipher == null || this.cipher.length() == 0) {
            return;
        }
        this.wrapCipher = this.createCipher(true);
        this.unwrapCipher = this.createCipher(false);
    }

    protected byte[] createIntegrityKey(boolean wrap) {
        ByteStringBuilder key = new ByteStringBuilder(this.hA1);
        if (wrap) {
            key.append(this.format == FORMAT.CLIENT ? CLIENT_MAGIC_INTEGRITY : SERVER_MAGIC_INTEGRITY);
        } else {
            key.append(this.format == FORMAT.CLIENT ? SERVER_MAGIC_INTEGRITY : CLIENT_MAGIC_INTEGRITY);
        }
        this.md5.reset();
        return this.md5.digest(key.toArray());
    }

    protected Cipher createCipher(boolean wrap) throws SaslException {
        Cipher ciph;
        byte[] cipherKeyBytes;
        byte[] hmacKey;
        int n = this.gethA1PrefixLength(this.cipher);
        ByteStringBuilder key = new ByteStringBuilder();
        key.append(this.hA1, 0, n);
        if (wrap) {
            key.append(this.format == FORMAT.CLIENT ? CLIENT_MAGIC_CONFIDENTIALITY : SERVER_MAGIC_CONFIDENTIALITY);
            hmacKey = this.md5.digest(key.toArray());
        } else {
            key.append(this.format == FORMAT.CLIENT ? SERVER_MAGIC_CONFIDENTIALITY : CLIENT_MAGIC_CONFIDENTIALITY);
            hmacKey = this.md5.digest(key.toArray());
        }
        byte[] IV = null;
        if (this.cipher.startsWith("rc")) {
            cipherKeyBytes = (byte[])hmacKey.clone();
        } else if (this.cipher.equals("des")) {
            cipherKeyBytes = Arrays.copyOf(hmacKey, 7);
            IV = Arrays.copyOfRange(hmacKey, 8, 16);
        } else if (this.cipher.equals("3des")) {
            cipherKeyBytes = Arrays.copyOf(hmacKey, 14);
            IV = Arrays.copyOfRange(hmacKey, 8, 16);
        } else {
            throw new SaslException("Unknown ciper (" + this.cipher + ")");
        }
        DefaultTransformationMapper trans = new DefaultTransformationMapper();
        try {
            SecretKey cipherKey;
            String alg;
            ciph = Cipher.getInstance(trans.getTransformationSpec("DIGEST-MD5", this.cipher).getTransformation());
            int slash = ciph.getAlgorithm().indexOf(47);
            String string = alg = slash > -1 ? ciph.getAlgorithm().substring(0, slash) : ciph.getAlgorithm();
            if (this.cipher.startsWith("rc")) {
                cipherKey = new SecretKeySpec(cipherKeyBytes, alg);
            } else if (this.cipher.equals("des")) {
                cipherKey = DigestUtil.createDesSecretKey(cipherKeyBytes, 0, cipherKeyBytes.length);
            } else if (this.cipher.equals("3des")) {
                cipherKey = DigestUtil.create3desSecretKey(cipherKeyBytes, 0, cipherKeyBytes.length);
            } else {
                throw new SaslException("Unsupported cipher (" + this.cipher + ")");
            }
            if (IV != null) {
                ciph.init(wrap ? 1 : 2, (Key)cipherKey, new IvParameterSpec(IV), this.secureRandomGenerator);
            } else {
                ciph.init(wrap ? 1 : 2, (Key)cipherKey, this.secureRandomGenerator);
            }
        }
        catch (Exception e) {
            throw new SaslException("Problem getting required cipher. Check your transformation mapper settings.", e);
        }
        return ciph;
    }

    private int gethA1PrefixLength(String cipher) {
        if (cipher.equals("rc4-40")) {
            return 5;
        }
        if (cipher.equals("rc4-56")) {
            return 7;
        }
        return 16;
    }

    private Mac getHmac() throws SaslException {
        try {
            return Mac.getInstance("HmacMD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SaslException("", e);
        }
    }

    protected class DigestWrapper
    implements SaslWrapper {
        private boolean confidential;

        protected DigestWrapper(boolean confidential) {
            this.confidential = confidential;
        }

        @Override
        public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
            if (this.confidential) {
                return AbstractDigestMechanism.this.wrapConfidentialityProtectedMessage(outgoing, offset, len);
            }
            return AbstractDigestMechanism.this.wrapIntegrityProtectedMessage(outgoing, offset, len);
        }

        @Override
        public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
            if (this.confidential) {
                return AbstractDigestMechanism.this.unwrapConfidentialityProtectedMessage(incoming, offset, len);
            }
            return AbstractDigestMechanism.this.unwrapIntegrityProtectedMessage(incoming, offset, len);
        }
    }

    public static enum FORMAT {
        CLIENT,
        SERVER;

    }
}

