/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.plain;

import java.io.IOException;
import java.util.NoSuchElementException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.sasl.callback.VerifyPasswordCallback;
import org.wildfly.security.sasl.util.SaslWrapper;
import org.wildfly.security.util.CodePointIterator;

final class PlainSaslServer
implements SaslServer,
SaslWrapper {
    private final CallbackHandler callbackHandler;
    private boolean complete;
    private String authorizedId;

    public PlainSaslServer(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    @Override
    public String getAuthorizationID() {
        if (!this.isComplete()) {
            throw ElytronMessages.log.saslAuthenticationNotComplete();
        }
        return this.authorizedId;
    }

    @Override
    public String getMechanismName() {
        return "PLAIN";
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        String password;
        String loginName;
        String authorizationId;
        if (this.complete) {
            throw ElytronMessages.log.saslMessageAfterComplete();
        }
        this.complete = true;
        if (response.length >= 65536) {
            throw ElytronMessages.log.saslMessageTooLong();
        }
        CodePointIterator i = CodePointIterator.ofUtf8Bytes(response);
        try {
            CodePointIterator delimIter = i.delimitedBy(0);
            authorizationId = delimIter.hasNext() ? delimIter.drainToString() : null;
            i.next();
            loginName = delimIter.drainToString();
            i.next();
            password = delimIter.drainToString();
            if (authorizationId == null) {
                authorizationId = loginName;
            }
        }
        catch (NoSuchElementException ignored) {
            throw ElytronMessages.log.saslInvalidMessageReceived();
        }
        NameCallback ncb = new NameCallback("PLAIN authentication identity", loginName);
        VerifyPasswordCallback vpc = new VerifyPasswordCallback(password);
        try {
            this.callbackHandler.handle(new Callback[]{ncb, vpc});
        }
        catch (SaslException e) {
            throw e;
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw ElytronMessages.log.saslServerSideAuthenticationFailed(e);
        }
        if (!vpc.isVerified()) {
            throw ElytronMessages.log.saslPasswordNotVerified();
        }
        AuthorizeCallback acb = new AuthorizeCallback(loginName, authorizationId);
        try {
            this.callbackHandler.handle(new Callback[]{acb});
        }
        catch (SaslException e) {
            throw e;
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw ElytronMessages.log.saslServerSideAuthenticationFailed(e);
        }
        if (!acb.isAuthorized()) {
            throw ElytronMessages.log.saslAuthorizationFailed(loginName, authorizationId);
        }
        this.authorizedId = acb.getAuthorizedID();
        return null;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (this.complete) {
            throw ElytronMessages.log.saslAuthenticationNotComplete();
        }
        throw ElytronMessages.log.saslNoSecurityLayer();
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (this.complete) {
            throw ElytronMessages.log.saslAuthenticationNotComplete();
        }
        throw ElytronMessages.log.saslNoSecurityLayer();
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        return null;
    }

    @Override
    public void dispose() throws SaslException {
    }
}

