/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security.auth.callback.ChannelBindingCallback;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServerFactory;

public final class ChannelBindingSaslServerFactory
extends AbstractDelegatingSaslServerFactory {
    private final String bindingType;
    private final byte[] bindingData;

    public ChannelBindingSaslServerFactory(SaslServerFactory delegate, String bindingType, byte[] bindingData) {
        super(delegate);
        this.bindingType = bindingType;
        this.bindingData = bindingData;
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, final CallbackHandler cbh) throws SaslException {
        return this.delegate.createSaslServer(mechanism, protocol, serverName, props, new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (!(callback instanceof ChannelBindingCallback)) continue;
                    ((ChannelBindingCallback)callback).setBindingType(ChannelBindingSaslServerFactory.this.bindingType);
                    ((ChannelBindingCallback)callback).setBindingData(ChannelBindingSaslServerFactory.this.bindingData);
                }
                cbh.handle(callbacks);
            }
        });
    }
}

