/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServerFactory;

public final class FilterMechanismSaslServerFactory
extends AbstractDelegatingSaslServerFactory {
    private final boolean include;
    private final Set<String> mechanisms;

    public FilterMechanismSaslServerFactory(SaslServerFactory delegate, boolean include, String ... mechanisms) {
        super(delegate);
        if (mechanisms == null) {
            throw new IllegalArgumentException("mechanisms is null");
        }
        this.include = include;
        HashSet<String> set = new HashSet<String>(mechanisms.length);
        Collections.addAll(set, mechanisms);
        this.mechanisms = set;
    }

    public FilterMechanismSaslServerFactory(SaslServerFactory delegate, boolean include, Collection<String> mechanisms) {
        super(delegate);
        if (mechanisms == null) {
            throw new IllegalArgumentException("mechanisms is null");
        }
        this.include = include;
        this.mechanisms = new HashSet<String>(mechanisms);
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        return this.mechanisms.contains(mechanism) != this.include ? null : this.delegate.createSaslServer(mechanism, protocol, serverName, props, cbh);
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        String[] names = this.delegate.getMechanismNames(props);
        ArrayList<String> list = new ArrayList<String>(names.length);
        for (String name : names) {
            if (this.mechanisms.contains(name) != this.include) continue;
            list.add(name);
        }
        return list.toArray(new String[list.size()]);
    }
}

