/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServer;
import org.wildfly.security.sasl.util.SaslWrapper;

public final class PrivilegedSaslServer
extends AbstractDelegatingSaslServer
implements SaslWrapper {
    private final AccessControlContext accessControlContext;

    PrivilegedSaslServer(SaslServer delegate, AccessControlContext accessControlContext) {
        super(delegate);
        if (delegate == null) {
            throw new IllegalArgumentException("delegate is null");
        }
        if (accessControlContext == null) {
            throw new IllegalArgumentException("accessControlContext is null");
        }
        this.accessControlContext = accessControlContext;
    }

    public PrivilegedSaslServer(SaslServer delegate) {
        this(delegate, AccessController.getContext());
    }

    @Override
    public byte[] evaluateResponse(final byte[] response) throws SaslException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws Exception {
                    return PrivilegedSaslServer.this.delegate.evaluateResponse(response);
                }
            }, this.accessControlContext);
        }
        catch (PrivilegedActionException pae) {
            try {
                throw pae.getCause();
            }
            catch (Error | RuntimeException | SaslException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new UndeclaredThrowableException(throwable);
            }
        }
    }

    @Override
    public byte[] unwrap(final byte[] incoming, final int offset, final int len) throws SaslException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws Exception {
                    return PrivilegedSaslServer.this.delegate.unwrap(incoming, offset, len);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            try {
                throw pae.getCause();
            }
            catch (Error | RuntimeException | SaslException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new UndeclaredThrowableException(throwable);
            }
        }
    }

    @Override
    public byte[] wrap(final byte[] outgoing, final int offset, final int len) throws SaslException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws Exception {
                    return PrivilegedSaslServer.this.delegate.wrap(outgoing, offset, len);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            try {
                throw pae.getCause();
            }
            catch (Error | RuntimeException | SaslException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new UndeclaredThrowableException(throwable);
            }
        }
    }
}

