/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImplFactory;
import java.nio.channels.ServerSocketChannel;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;

abstract class AbstractDelegatingSSLServerSocket
extends SSLServerSocket {
    private final SSLServerSocket delegate;

    AbstractDelegatingSSLServerSocket(SSLServerSocket delegate) throws IOException {
        this.delegate = delegate;
    }

    @Override
    public void bind(SocketAddress endpoint) throws IOException {
        this.delegate.bind(endpoint);
    }

    @Override
    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        this.delegate.bind(endpoint, backlog);
    }

    @Override
    public InetAddress getInetAddress() {
        return this.delegate.getInetAddress();
    }

    @Override
    public int getLocalPort() {
        return this.delegate.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.delegate.getLocalSocketAddress();
    }

    @Override
    public Socket accept() throws IOException {
        return this.delegate.accept();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public ServerSocketChannel getChannel() {
        return this.delegate.getChannel();
    }

    @Override
    public boolean isBound() {
        return this.delegate.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.delegate.setSoTimeout(timeout);
    }

    @Override
    public int getSoTimeout() throws IOException {
        return this.delegate.getSoTimeout();
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.delegate.setReuseAddress(on);
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.delegate.getReuseAddress();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    public static void setSocketFactory(SocketImplFactory fac) throws IOException {
        ServerSocket.setSocketFactory(fac);
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        this.delegate.setReceiveBufferSize(size);
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.delegate.getReceiveBufferSize();
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.delegate.setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.delegate.getEnabledCipherSuites();
    }

    @Override
    public void setEnabledCipherSuites(String[] names) throws IllegalArgumentException {
        this.delegate.setEnabledCipherSuites(names);
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public String[] getSupportedProtocols() {
        return this.delegate.getSupportedProtocols();
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.delegate.getEnabledProtocols();
    }

    @Override
    public void setEnabledProtocols(String[] names) throws IllegalArgumentException {
        this.delegate.setEnabledProtocols(names);
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        this.delegate.setNeedClientAuth(need);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.delegate.getNeedClientAuth();
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.delegate.setWantClientAuth(want);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.delegate.getWantClientAuth();
    }

    @Override
    public void setUseClientMode(boolean clientMode) {
        this.delegate.setUseClientMode(clientMode);
    }

    @Override
    public boolean getUseClientMode() {
        return this.delegate.getUseClientMode();
    }

    @Override
    public void setEnableSessionCreation(boolean enabled) {
        this.delegate.setEnableSessionCreation(enabled);
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.delegate.getEnableSessionCreation();
    }

    @Override
    public SSLParameters getSSLParameters() {
        return this.delegate.getSSLParameters();
    }

    @Override
    public void setSSLParameters(SSLParameters parameters) {
        this.delegate.setSSLParameters(parameters);
    }
}

