/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.sts.registry;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.picketlink.identity.federation.core.sts.registry.AbstractJPARegistry;
import org.picketlink.identity.federation.core.sts.registry.RevocationRegistry;
import org.picketlink.identity.federation.core.sts.registry.RevokedToken;

public class JPABasedRevocationRegistry
extends AbstractJPARegistry
implements RevocationRegistry {
    public JPABasedRevocationRegistry() {
    }

    public JPABasedRevocationRegistry(String configuration) {
        super(configuration);
    }

    @Override
    public boolean isRevoked(String tokenType, String id) {
        EntityManager manager = this.getEntityManagerFactory().createEntityManager();
        Object object = manager.find(RevokedToken.class, (Object)id);
        manager.close();
        return object != null;
    }

    @Override
    public void revokeToken(String tokenType, String id) {
        EntityManager manager = this.getEntityManagerFactory().createEntityManager();
        if (manager.find(RevokedToken.class, (Object)id) != null) {
            logger.debug("Token with id=" + id + " has already been cancelled");
        } else {
            RevokedToken revokedToken = new RevokedToken(tokenType, id);
            EntityTransaction transaction = manager.getTransaction();
            transaction.begin();
            manager.persist((Object)revokedToken);
            transaction.commit();
        }
        manager.close();
    }
}

