/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.infinispan.objectfilter.impl.BaseMatcher;
import org.infinispan.objectfilter.impl.FilterRegistry;
import org.infinispan.objectfilter.impl.FilterSubscriptionImpl;
import org.infinispan.objectfilter.impl.MetadataAdapter;
import org.infinispan.objectfilter.impl.hql.FilterProcessingChain;
import org.infinispan.objectfilter.impl.hql.ProtobufEntityNamesResolver;
import org.infinispan.objectfilter.impl.hql.ProtobufPropertyHelper;
import org.infinispan.objectfilter.impl.predicateindex.ProtobufMatcherEvalContext;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.JavaType;

public final class ProtobufMatcher
extends BaseMatcher<Descriptor, FieldDescriptor, Integer> {
    private final SerializationContext serializationContext;
    private final ProtobufEntityNamesResolver entityNamesResolver;
    private final ProtobufPropertyHelper propertyHelper;
    private final Descriptor wrappedMessageDescriptor;

    public ProtobufMatcher(SerializationContext serializationContext) {
        this.serializationContext = serializationContext;
        this.wrappedMessageDescriptor = serializationContext.getMessageDescriptor("org.infinispan.protostream.WrappedMessage");
        this.entityNamesResolver = new ProtobufEntityNamesResolver(serializationContext);
        this.propertyHelper = new ProtobufPropertyHelper(this.entityNamesResolver, serializationContext);
    }

    protected ProtobufMatcherEvalContext startContext(Object userContext, Object instance, Object eventType) {
        FilterRegistry<Descriptor, FieldDescriptor, Integer> filterRegistry;
        ProtobufMatcherEvalContext context = this.createContext(userContext, instance, eventType);
        if (context.getEntityType() != null && (filterRegistry = this.getFilterRegistryForType(context.getEntityType())) != null) {
            context.initMultiFilterContext(filterRegistry);
            return context;
        }
        return null;
    }

    protected ProtobufMatcherEvalContext startContext(Object userContext, Object instance, FilterSubscriptionImpl<Descriptor, FieldDescriptor, Integer> filterSubscription, Object eventType) {
        ProtobufMatcherEvalContext ctx = this.createContext(userContext, instance, eventType);
        return ctx.getEntityType() != null && ctx.getEntityType().getFullName().equals(filterSubscription.getEntityTypeName()) ? ctx : null;
    }

    protected ProtobufMatcherEvalContext createContext(Object userContext, Object instance, Object eventType) {
        ProtobufMatcherEvalContext ctx = new ProtobufMatcherEvalContext(userContext, instance, eventType, this.wrappedMessageDescriptor, this.serializationContext);
        ctx.unwrapPayload();
        return ctx;
    }

    @Override
    protected FilterProcessingChain<Descriptor> createFilterProcessingChain(Map<String, Object> namedParameters) {
        return FilterProcessingChain.build(this.entityNamesResolver, this.propertyHelper, namedParameters);
    }

    @Override
    protected FilterRegistry<Descriptor, FieldDescriptor, Integer> getFilterRegistryForType(Descriptor entityType) {
        return (FilterRegistry)this.filtersByTypeName.get(entityType.getFullName());
    }

    @Override
    protected MetadataAdapter<Descriptor, FieldDescriptor, Integer> createMetadataAdapter(Descriptor messageDescriptor) {
        return new MetadataAdapterImpl(messageDescriptor);
    }

    private static class MetadataAdapterImpl
    implements MetadataAdapter<Descriptor, FieldDescriptor, Integer> {
        private final Descriptor messageDescriptor;

        MetadataAdapterImpl(Descriptor messageDescriptor) {
            this.messageDescriptor = messageDescriptor;
        }

        @Override
        public String getTypeName() {
            return this.messageDescriptor.getFullName();
        }

        @Override
        public Descriptor getTypeMetadata() {
            return this.messageDescriptor;
        }

        @Override
        public List<Integer> translatePropertyPath(List<String> path) {
            ArrayList<Integer> propPath = new ArrayList<Integer>(path.size());
            Descriptor md = this.messageDescriptor;
            for (String prop : path) {
                FieldDescriptor fd = md.findFieldByName(prop);
                propPath.add(fd.getNumber());
                if (fd.getJavaType() == JavaType.MESSAGE) {
                    md = fd.getMessageType();
                    continue;
                }
                md = null;
            }
            return propPath;
        }

        @Override
        public boolean isRepeatedProperty(List<String> propertyPath) {
            Descriptor md = this.messageDescriptor;
            for (String prop : propertyPath) {
                FieldDescriptor fd = md.findFieldByName(prop);
                if (fd.isRepeated()) {
                    return true;
                }
                if (fd.getJavaType() == JavaType.MESSAGE) {
                    md = fd.getMessageType();
                    continue;
                }
                md = null;
            }
            return false;
        }

        @Override
        public FieldDescriptor makeChildAttributeMetadata(FieldDescriptor parentAttributeMetadata, Integer attribute) {
            return parentAttributeMetadata == null ? this.messageDescriptor.findFieldByNumber(attribute.intValue()) : parentAttributeMetadata.getMessageType().findFieldByNumber(attribute.intValue());
        }

        @Override
        public boolean isComparableProperty(FieldDescriptor attributeMetadata) {
            switch (attributeMetadata.getJavaType()) {
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case STRING: 
                case BYTE_STRING: 
                case ENUM: {
                    return true;
                }
            }
            return false;
        }
    }
}

