/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.access.management.JmxAuthorizer;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.extension.RuntimeHostControllerInfoAccessor;
import org.jboss.as.jmx.JMXSubsystemAdd;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.dmr.ModelNode;

public class JMXSubsystemRemove
extends AbstractRemoveStepHandler {
    private final ManagedAuditLogger auditLoggerInfo;
    private final JmxAuthorizer authorizer;
    private final RuntimeHostControllerInfoAccessor hostInfoAccessor;

    JMXSubsystemRemove(ManagedAuditLogger auditLoggerInfo, JmxAuthorizer authorizer, RuntimeHostControllerInfoAccessor hostInfoAccessor) {
        this.auditLoggerInfo = auditLoggerInfo;
        this.authorizer = authorizer;
        this.hostInfoAccessor = hostInfoAccessor;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        if (this.isRemoveService(context)) {
            context.removeService(MBeanServerService.SERVICE_NAME);
        } else {
            context.reloadRequired();
        }
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (this.isRemoveService(context)) {
            JMXSubsystemAdd.launchServices(context, model, this.auditLoggerInfo, this.authorizer, this.hostInfoAccessor);
        } else {
            context.revertReloadRequired();
        }
    }

    private boolean isRemoveService(OperationContext context) {
        if (context.isNormalServer() && context.isResourceServiceRestartAllowed()) {
            context.removeService(MBeanServerService.SERVICE_NAME);
            return true;
        }
        return false;
    }
}

