/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.webservices.dmr.Attributes;
import org.jboss.as.webservices.dmr.PackageUtils;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.as.webservices.service.HandlerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

final class HandlerAdd
extends AbstractAddStepHandler {
    static final HandlerAdd INSTANCE = new HandlerAdd();
    static final AtomicInteger counter = new AtomicInteger(0);

    private HandlerAdd() {
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        super.rollbackRuntime(context, operation, resource);
        if (!context.isBooting()) {
            context.revertReloadRequired();
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.isBooting()) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            PathElement confElem = address.getElement(address.size() - 3);
            String configType = confElem.getKey();
            String configName = confElem.getValue();
            String handlerChainType = address.getElement(address.size() - 2).getKey();
            String handlerChainId = address.getElement(address.size() - 2).getValue();
            String handlerName = address.getElement(address.size() - 1).getValue();
            String handlerClass = operation.require("class").asString();
            HandlerService service = new HandlerService(handlerName, handlerClass, counter.incrementAndGet());
            ServiceTarget target = context.getServiceTarget();
            ServiceName configServiceName = PackageUtils.getConfigServiceName(configType, configName);
            ServiceRegistry registry = context.getServiceRegistry(false);
            if (registry.getService(configServiceName) == null) {
                throw WSLogger.ROOT_LOGGER.missingConfig(configName);
            }
            ServiceName handlerChainServiceName = PackageUtils.getHandlerChainServiceName(configServiceName, handlerChainType, handlerChainId);
            if (registry.getService(handlerChainServiceName) == null) {
                throw WSLogger.ROOT_LOGGER.missingHandlerChain(configName, handlerChainType, handlerChainId);
            }
            ServiceName handlerServiceName = PackageUtils.getHandlerServiceName(handlerChainServiceName, handlerName);
            ServiceBuilder handlerServiceBuilder = target.addService(handlerServiceName, (Service)service);
            ServiceController serviceController = handlerServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        } else {
            context.reloadRequired();
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        Attributes.CLASS.validateAndSet(operation, model);
    }
}

