/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.audit;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.as.controller.audit.AuditLogHandler;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.protocol.StreamUtils;
import org.xnio.IoUtils;

public abstract class AbstractFileAuditLogHandler
extends AuditLogHandler {
    protected static final byte[] LINE_TERMINATOR = String.format("%n", new Object[0]).getBytes();
    private final PathManagerService pathManager;
    private final String path;
    private final String relativeTo;
    private volatile File file;

    public AbstractFileAuditLogHandler(String name, String formatterName, int maxFailureCount, PathManagerService pathManager, String path, String relativeTo) {
        super(name, formatterName, maxFailureCount);
        this.pathManager = pathManager;
        this.path = path;
        this.relativeTo = relativeTo;
    }

    @Override
    void initialize() {
        if (this.file == null) {
            File file = new File(this.pathManager.resolveRelativePathEntry(this.path, this.relativeTo));
            if (file.exists() && file.isDirectory()) {
                throw ControllerLogger.ROOT_LOGGER.resolvedFileDoesNotExistOrIsDirectory(file);
            }
            File parent = file.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            this.initializeAtStartup(file);
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.file = file;
        }
        this.rotateLogFile(this.file);
    }

    protected abstract void initializeAtStartup(File var1);

    protected abstract void rotateLogFile(File var1);

    @Override
    void stop() {
        this.file = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void writeLogItem(String formattedItem) throws IOException {
        FileOutputStream fos = new FileOutputStream(this.file, true);
        BufferedOutputStream output = new BufferedOutputStream(fos);
        try {
            output.write(formattedItem.getBytes());
            output.write(LINE_TERMINATOR);
            output.flush();
            fos.getFD().sync();
        }
        finally {
            IoUtils.safeClose((Closeable)output);
        }
    }

    @Override
    boolean isDifferent(AuditLogHandler other) {
        if (!(other instanceof AbstractFileAuditLogHandler)) {
            return true;
        }
        AbstractFileAuditLogHandler otherHandler = (AbstractFileAuditLogHandler)other;
        if (!this.name.equals(otherHandler.name)) {
            return true;
        }
        if (!this.getFormatterName().equals(otherHandler.getFormatterName())) {
            return true;
        }
        if (!this.path.equals(otherHandler.path)) {
            return true;
        }
        return !this.compare(this.relativeTo, otherHandler.relativeTo);
    }

    private boolean compare(Object one, Object two) {
        if (one == null && two == null) {
            return true;
        }
        if (one == null && two != null) {
            return false;
        }
        if (one != null && two == null) {
            return false;
        }
        return one.equals(two);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFile(File file, File backup) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            FileOutputStream fos = new FileOutputStream(backup);
            BufferedOutputStream output = new BufferedOutputStream(fos);
            try {
                StreamUtils.copyStream((InputStream)in, (OutputStream)output);
                output.flush();
                fos.getFD().sync();
                fos.close();
            }
            finally {
                StreamUtils.safeClose((Closeable)output);
            }
        }
        finally {
            StreamUtils.safeClose((Closeable)in);
        }
    }

    protected void rename(File file, File to) throws IOException {
        if (!file.renameTo(to) && file.exists()) {
            this.copyFile(file, to);
            file.delete();
        }
    }
}

