/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.service;

import java.security.Provider;
import java.security.Security;
import java.util.List;
import javax.management.MBeanServer;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.webservices.config.ServerConfigImpl;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.jboss.wsf.spi.management.ServerConfig;
import org.wildfly.extension.undertow.UndertowService;

public final class ServerConfigService
implements Service<ServerConfig> {
    private static final ServiceName MBEAN_SERVER_NAME = ServiceName.JBOSS.append(new String[]{"mbean", "server"});
    private final ServerConfigImpl serverConfig;

    private ServerConfigService(ServerConfigImpl serverConfig) {
        this.serverConfig = serverConfig;
    }

    public ServerConfig getValue() {
        return this.serverConfig;
    }

    public void start(StartContext context) throws StartException {
        try {
            this.serverConfig.create();
            ServerConfigService.fixSecurityProvider();
        }
        catch (Exception e) {
            WSLogger.ROOT_LOGGER.configServiceCreationFailed();
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext context) {
        try {
            this.serverConfig.destroy();
        }
        catch (Exception e) {
            WSLogger.ROOT_LOGGER.configServiceDestroyFailed();
        }
    }

    public static ServiceController<?> install(ServiceTarget serviceTarget, ServerConfigImpl serverConfig, List<ServiceName> dependencies, boolean jmxSubsystemAvailable) {
        ServiceBuilder builder = serviceTarget.addService(WSServices.CONFIG_SERVICE, (Service)new ServerConfigService(serverConfig));
        if (jmxSubsystemAvailable) {
            builder.addDependency(ServiceBuilder.DependencyType.REQUIRED, MBEAN_SERVER_NAME, MBeanServer.class, serverConfig.getMBeanServerInjector());
        } else {
            serverConfig.getMBeanServerInjector().setValue((Value)new ImmediateValue(null));
        }
        builder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, serverConfig.getServerEnvironmentInjector());
        builder.addDependency(ServiceBuilder.DependencyType.REQUIRED, UndertowService.UNDERTOW, UndertowService.class, serverConfig.getUndertowServiceInjector());
        for (ServiceName dep : dependencies) {
            builder.addDependency(dep);
        }
        builder.setInitialMode(ServiceController.Mode.ACTIVE);
        return builder.install();
    }

    private static void fixSecurityProvider() {
        ServerConfigService.reorderProviders();
    }

    private static void reorderProviders() {
        Provider bc = Security.getProvider("BC");
        if (bc != null) {
            int index = -1;
            Provider[] providers = Security.getProviders();
            for (int i = 0; i < providers.length; ++i) {
                Provider provider = providers[i];
                if (!provider.getName().equals("SunJCE") && !provider.getName().equals("IBMJCE")) continue;
                index = i;
                break;
            }
            Security.removeProvider(bc.getName());
            if (index > -1) {
                Security.insertProviderAt(bc, index + 1);
            } else {
                Security.insertProviderAt(bc, providers.length);
            }
        }
    }
}

