/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.spi;

import java.io.IOException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.hibernate.search.backend.spi.DeletionQuery;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.util.impl.ScopedAnalyzer;

public final class SingularTermDeletionQuery
implements DeletionQuery {
    public static final int QUERY_KEY = 0;
    private final String fieldName;
    private final Object value;
    private final Type type;

    public SingularTermDeletionQuery(String fieldName, String value) {
        this(fieldName, value, Type.STRING);
    }

    public SingularTermDeletionQuery(String fieldName, int value) {
        this(fieldName, value, Type.INT);
    }

    public SingularTermDeletionQuery(String fieldName, long value) {
        this(fieldName, value, Type.LONG);
    }

    public SingularTermDeletionQuery(String fieldName, float value) {
        this(fieldName, Float.valueOf(value), Type.FLOAT);
    }

    public SingularTermDeletionQuery(String fieldName, double value) {
        this(fieldName, value, Type.DOUBLE);
    }

    public SingularTermDeletionQuery(String fieldName, Object value, Type type) {
        this.fieldName = fieldName;
        this.value = value;
        this.type = type;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getValue() {
        return this.value;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int getQueryKey() {
        return 0;
    }

    public String toString() {
        return "SingularTermQuery: +" + this.fieldName + ":" + this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query toLuceneQuery(ScopedAnalyzer analyzerForEntity) {
        BytesRef valueAsBytes;
        if (this.getType() == Type.STRING) {
            Object value;
            TokenStream tokenStream = analyzerForEntity.tokenStream(this.getFieldName(), (String)this.getValue());
            tokenStream.reset();
            try {
                BooleanQuery booleanQuery = new BooleanQuery();
                while (tokenStream.incrementToken()) {
                    value = ((CharTermAttribute)tokenStream.getAttribute(CharTermAttribute.class)).toString();
                    booleanQuery.add((Query)new TermQuery(new Term(this.getFieldName(), (String)value)), BooleanClause.Occur.MUST);
                }
                value = booleanQuery;
            }
            catch (Throwable throwable) {
                try {
                    tokenStream.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AssertionFailure("no IOException can occur while using a TokenStream that is generated via String");
                }
            }
            tokenStream.close();
            return value;
        }
        Type type = this.getType();
        switch (type) {
            case INT: 
            case FLOAT: {
                int value = type == Type.FLOAT ? NumericUtils.floatToSortableInt((float)((Float)this.getValue()).floatValue()) : (Integer)this.getValue();
                BytesRefBuilder builder = new BytesRefBuilder();
                NumericUtils.intToPrefixCoded((int)value, (int)0, (BytesRefBuilder)builder);
                valueAsBytes = builder.get();
                break;
            }
            case LONG: 
            case DOUBLE: {
                long value = type == Type.DOUBLE ? NumericUtils.doubleToSortableLong((double)((Double)this.getValue())) : (Long)this.getValue();
                BytesRefBuilder builder = new BytesRefBuilder();
                NumericUtils.longToPrefixCoded((long)value, (int)0, (BytesRefBuilder)builder);
                valueAsBytes = builder.get();
                break;
            }
            default: {
                throw new AssertionFailure("has to be a Numeric Type at this point!");
            }
        }
        return new TermQuery(new Term(this.getFieldName(), valueAsBytes));
    }

    @Override
    public String[] serialize() {
        return new String[]{this.getType().toString(), this.getFieldName(), String.valueOf(this.getValue())};
    }

    public static SingularTermDeletionQuery fromString(String[] string) {
        if (string.length != 3) {
            throw new IllegalArgumentException("for a TermQuery to work there have to be exactly 3 Arguments (type & fieldName & value");
        }
        Type type = Type.valueOf(string[0]);
        switch (type) {
            case STRING: {
                return new SingularTermDeletionQuery(string[1], string[2]);
            }
            case INT: {
                return new SingularTermDeletionQuery(string[1], Integer.parseInt(string[2]));
            }
            case FLOAT: {
                return new SingularTermDeletionQuery(string[1], Float.parseFloat(string[2]));
            }
            case LONG: {
                return new SingularTermDeletionQuery(string[1], Long.parseLong(string[2]));
            }
            case DOUBLE: {
                return new SingularTermDeletionQuery(string[1], Double.parseDouble(string[2]));
            }
        }
        throw new AssertionFailure("wrong Type!");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingularTermDeletionQuery other = (SingularTermDeletionQuery)obj;
        if (this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public static enum Type {
        STRING,
        INT,
        LONG,
        FLOAT,
        DOUBLE;

    }
}

