/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.anonymous;

import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.sasl.SaslException;
import org.wildfly.security.sasl.util.AbstractSaslClient;
import org.wildfly.security.sasl.util.StringPrep;
import org.wildfly.security.util.ByteStringBuilder;

public final class AnonymousSaslClient
extends AbstractSaslClient {
    private static final int INITIAL_STATE = 1;

    protected AnonymousSaslClient(String protocol, String serverName, CallbackHandler callbackHandler, String authorizationId) {
        super("ANONYMOUS", protocol, serverName, callbackHandler, authorizationId, true);
        this.setNegotiationState(1);
    }

    @Override
    protected byte[] evaluateMessage(int state, byte[] message) throws SaslException {
        switch (state) {
            case 1: {
                if (message != null && message.length > 0) {
                    throw new SaslException("Invalid challenge received from server");
                }
                NameCallback nameCallback = new NameCallback("Authentication name");
                this.handleCallbacks(nameCallback);
                String name = nameCallback.getName();
                if (name == null) {
                    throw new SaslException("Authentication name is missing");
                }
                if (name.length() > 255) {
                    throw new SaslException("Authentication name string is too long");
                }
                if (name.isEmpty()) {
                    throw new SaslException("Authentication name is empty");
                }
                ByteStringBuilder b = new ByteStringBuilder();
                StringPrep.encode(name, b, 7159L);
                this.negotiationComplete();
                return b.toArray();
            }
        }
        throw new SaslException("Invalid state");
    }
}

