/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.wildfly.security.ssl.AbstractDelegatingSSLEngine;
import org.wildfly.security.ssl.CipherSuiteSelector;
import org.wildfly.security.ssl.ProtocolSelector;

final class ConfiguredSSLEngine
extends AbstractDelegatingSSLEngine {
    private final ProtocolSelector protocolSelector;
    private final CipherSuiteSelector cipherSuiteSelector;

    ConfiguredSSLEngine(SSLEngine delegate, ProtocolSelector protocolSelector, CipherSuiteSelector cipherSuiteSelector) {
        super(delegate);
        this.protocolSelector = protocolSelector;
        this.cipherSuiteSelector = cipherSuiteSelector;
        delegate.setEnabledProtocols(protocolSelector.evaluate(delegate.getSupportedProtocols()));
        delegate.setEnabledCipherSuites(cipherSuiteSelector.evaluate(delegate.getSupportedCipherSuites()));
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
    }

    @Override
    public void setSSLParameters(SSLParameters params) {
        super.setSSLParameters(params);
        super.setEnabledProtocols(this.protocolSelector.evaluate(super.getSupportedProtocols()));
        super.setEnabledCipherSuites(this.cipherSuiteSelector.evaluate(super.getSupportedCipherSuites()));
    }
}

