/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.str;

import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SAMLKeyInfoProcessor;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.token.BinarySecurity;
import org.apache.wss4j.dom.message.token.DerivedKeyToken;
import org.apache.wss4j.dom.message.token.Reference;
import org.apache.wss4j.dom.message.token.SecurityTokenReference;
import org.apache.wss4j.dom.message.token.UsernameToken;
import org.apache.wss4j.dom.processor.Processor;
import org.apache.wss4j.dom.saml.WSSSAMLKeyInfoProcessor;
import org.apache.wss4j.dom.str.STRParser;
import org.apache.wss4j.dom.str.STRParserUtil;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.w3c.dom.Element;

public class SecurityTokenRefSTRParser
implements STRParser {
    public static final String SIGNATURE_METHOD = "signature_method";
    private byte[] secretKey;
    private Principal principal;

    @Override
    public void parseSecurityTokenReference(Element strElement, RequestData data, WSDocInfo wsDocInfo, Map<String, Object> parameters) throws WSSecurityException {
        WSSecurityEngineResult result;
        SecurityTokenReference secRef = new SecurityTokenReference(strElement, data.getBSPEnforcer());
        String uri = null;
        if (secRef.containsReference()) {
            uri = secRef.getReference().getURI();
            if (uri.charAt(0) == '#') {
                uri = uri.substring(1);
            }
        } else if (secRef.containsKeyIdentifier()) {
            uri = secRef.getKeyIdentifierValue();
        }
        if ((result = wsDocInfo.getResult(uri)) != null) {
            this.processPreviousResult(result, secRef, data, parameters, wsDocInfo);
            if (this.secretKey == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, "unsupportedKeyId", new Object[]{uri});
            }
        } else if (secRef.containsReference()) {
            Element token;
            QName el;
            Reference reference = secRef.getReference();
            this.secretKey = this.getSecretKeyFromToken(uri, reference.getValueType(), data);
            if (this.secretKey == null && (el = new QName((token = secRef.getTokenElement(strElement.getOwnerDocument(), wsDocInfo, data.getCallbackHandler())).getNamespaceURI(), token.getLocalName())).equals(WSSecurityEngine.BINARY_TOKEN)) {
                Processor proc = data.getWssConfig().getProcessor(WSSecurityEngine.BINARY_TOKEN);
                List<WSSecurityEngineResult> bstResult = proc.handleToken(token, data, wsDocInfo);
                BinarySecurity bstToken = (BinarySecurity)bstResult.get(0).get("binary-security-token");
                STRParserUtil.checkBinarySecurityBSPCompliance(secRef, bstToken, data.getBSPEnforcer());
                this.secretKey = (byte[])bstResult.get(0).get("secret");
            }
            if (this.secretKey == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, "unsupportedKeyId", new Object[]{uri});
            }
        } else if (secRef.containsKeyIdentifier()) {
            String valueType = secRef.getKeyIdentifierValueType();
            if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(valueType) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(valueType)) {
                this.secretKey = this.getSecretKeyFromToken(secRef.getKeyIdentifierValue(), valueType, data);
                if (this.secretKey == null) {
                    SamlAssertionWrapper samlAssertion = STRParserUtil.getAssertionFromKeyIdentifier(secRef, strElement, data, wsDocInfo);
                    this.secretKey = this.getSecretKeyFromAssertion(samlAssertion, secRef, data, wsDocInfo);
                }
            } else if ("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5APREQSHA1".equals(valueType)) {
                this.secretKey = this.getSecretKeyFromToken(secRef.getKeyIdentifierValue(), valueType, data);
                if (this.secretKey == null) {
                    byte[] keyBytes = secRef.getSKIBytes();
                    List<WSSecurityEngineResult> resultsList = wsDocInfo.getResultsByTag(4096);
                    for (WSSecurityEngineResult bstResult : resultsList) {
                        BinarySecurity bstToken = (BinarySecurity)bstResult.get("binary-security-token");
                        byte[] tokenDigest = WSSecurityUtil.generateDigest(bstToken.getToken());
                        if (!Arrays.equals(tokenDigest, keyBytes)) continue;
                        this.secretKey = (byte[])bstResult.get("secret");
                        break;
                    }
                }
                if (this.secretKey == null) {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, "unsupportedKeyId", new Object[]{uri});
                }
            } else {
                if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1".equals(valueType)) {
                    STRParserUtil.checkEncryptedKeyBSPCompliance(secRef, data.getBSPEnforcer());
                }
                this.secretKey = this.getSecretKeyFromToken(secRef.getKeyIdentifierValue(), secRef.getKeyIdentifierValueType(), data);
                if (this.secretKey == null) {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, "unsupportedKeyId", new Object[]{uri});
                }
            }
        } else {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, "noReference", new Object[0]);
        }
    }

    @Override
    public X509Certificate[] getCertificates() {
        return null;
    }

    @Override
    public Principal getPrincipal() {
        return this.principal;
    }

    @Override
    public PublicKey getPublicKey() {
        return null;
    }

    @Override
    public byte[] getSecretKey() {
        return this.secretKey;
    }

    @Override
    public STRParser.REFERENCE_TYPE getCertificatesReferenceType() {
        return null;
    }

    @Override
    public boolean isTrustedCredential() {
        return false;
    }

    private byte[] getSecretKeyFromToken(String id, String type, RequestData data) throws WSSecurityException {
        if (id.charAt(0) == '#') {
            id = id.substring(1);
        }
        WSPasswordCallback pwcb = new WSPasswordCallback(id, null, type, 9);
        try {
            Callback[] callbacks = new Callback[]{pwcb};
            if (data.getCallbackHandler() != null) {
                data.getCallbackHandler().handle(callbacks);
                return pwcb.getKey();
            }
        }
        catch (Exception e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noPassword", e, new Object[]{id});
        }
        return null;
    }

    private byte[] getSecretKeyFromAssertion(SamlAssertionWrapper samlAssertion, SecurityTokenReference secRef, RequestData data, WSDocInfo wsDocInfo) throws WSSecurityException {
        STRParserUtil.checkSamlTokenBSPCompliance(secRef, samlAssertion, data.getBSPEnforcer());
        SAMLKeyInfo samlKi = SAMLUtil.getCredentialFromSubject((SamlAssertionWrapper)samlAssertion, (SAMLKeyInfoProcessor)new WSSSAMLKeyInfoProcessor(data, wsDocInfo), (Crypto)data.getSigVerCrypto(), (CallbackHandler)data.getCallbackHandler());
        if (samlKi == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, "invalidSAMLToken", new Object[]{"No Secret Key"});
        }
        return samlKi.getSecret();
    }

    private void processPreviousResult(WSSecurityEngineResult result, SecurityTokenReference secRef, RequestData data, Map<String, Object> parameters, WSDocInfo wsDocInfo) throws WSSecurityException {
        int action = (Integer)result.get("action");
        if (4 == action) {
            STRParserUtil.checkEncryptedKeyBSPCompliance(secRef, data.getBSPEnforcer());
            this.secretKey = (byte[])result.get("secret");
        } else if (2048 == action) {
            DerivedKeyToken dkt = (DerivedKeyToken)result.get("derived-key-token");
            byte[] secret = (byte[])result.get("secret");
            String algorithm = (String)parameters.get(SIGNATURE_METHOD);
            this.secretKey = dkt.deriveKey(KeyUtils.getKeyLength((String)algorithm), secret);
            this.principal = dkt.createPrincipal();
        } else if (8 == action || 16 == action) {
            SamlAssertionWrapper samlAssertion = (SamlAssertionWrapper)result.get("saml-assertion");
            this.secretKey = this.getSecretKeyFromAssertion(samlAssertion, secRef, data, wsDocInfo);
        } else if (1024 == action || 4096 == action) {
            this.secretKey = (byte[])result.get("secret");
        } else if (8192 == action || 1 == action) {
            STRParserUtil.checkUsernameTokenBSPCompliance(secRef, data.getBSPEnforcer());
            UsernameToken usernameToken = (UsernameToken)result.get("username-token");
            usernameToken.setRawPassword(data);
            this.secretKey = usernameToken.getDerivedKey(data.getBSPEnforcer());
        }
    }
}

