/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.suspend;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.suspend.CountingRequestCountCallback;
import org.jboss.as.server.suspend.OperationListener;
import org.jboss.as.server.suspend.ServerActivity;
import org.jboss.as.server.suspend.ServerActivityCallback;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class SuspendController
implements Service<SuspendController> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"server", "suspend-controller"});
    private Timer timer;
    private State state = State.RUNNING;
    private final List<ServerActivity> activities = new ArrayList<ServerActivity>();
    private final List<OperationListener> operationListeners = new ArrayList<OperationListener>();
    private int outstandingCount;
    private final ServerActivityCallback listener = new ServerActivityCallback(){

        @Override
        public void done() {
            SuspendController.this.activityPaused();
        }
    };

    public synchronized void suspend(long timeoutMillis) {
        ServerLogger.ROOT_LOGGER.suspendingServer();
        this.state = State.PRE_SUSPEND;
        for (OperationListener listener : new ArrayList<OperationListener>(this.operationListeners)) {
            listener.suspendStarted();
        }
        this.outstandingCount = this.activities.size();
        if (this.outstandingCount == 0) {
            this.handlePause();
        } else {
            CountingRequestCountCallback cb = new CountingRequestCountCallback(this.outstandingCount, new ServerActivityCallback(){

                @Override
                public void done() {
                    SuspendController.this.state = State.SUSPENDING;
                    for (ServerActivity activity : SuspendController.this.activities) {
                        activity.suspended(SuspendController.this.listener);
                    }
                }
            });
            for (ServerActivity activity : this.activities) {
                activity.preSuspend(cb);
            }
            this.timer = new Timer();
            if (timeoutMillis > 0L) {
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        SuspendController.this.timeout();
                    }
                }, timeoutMillis);
            }
        }
    }

    public synchronized void resume() {
        if (this.state == State.RUNNING) {
            return;
        }
        ServerLogger.ROOT_LOGGER.resumingServer();
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        for (OperationListener listener : new ArrayList<OperationListener>(this.operationListeners)) {
            listener.cancelled();
        }
        for (ServerActivity activity : this.activities) {
            try {
                activity.resume();
            }
            catch (Exception e) {
                ServerLogger.ROOT_LOGGER.failedToResume(activity);
            }
        }
        this.state = State.RUNNING;
    }

    public synchronized void registerActivity(ServerActivity activity) {
        this.activities.add(activity);
    }

    public synchronized void unRegisterActivity(ServerActivity activity) {
        this.activities.remove(activity);
    }

    public synchronized void start(StartContext startContext) throws StartException {
        this.state = State.RUNNING;
    }

    public synchronized void stop(StopContext stopContext) {
    }

    public State getState() {
        return this.state;
    }

    synchronized void activityPaused() {
        --this.outstandingCount;
        this.handlePause();
    }

    private void handlePause() {
        if (this.outstandingCount == 0) {
            this.state = State.SUSPENDED;
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            for (OperationListener listener : new ArrayList<OperationListener>(this.operationListeners)) {
                listener.complete();
            }
        }
    }

    synchronized void timeout() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        for (OperationListener listener : new ArrayList<OperationListener>(this.operationListeners)) {
            listener.timeout();
        }
    }

    public synchronized void addListener(OperationListener listener) {
        this.operationListeners.add(listener);
    }

    public synchronized void removeListener(OperationListener listener) {
        this.operationListeners.remove(listener);
    }

    public SuspendController getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public static enum State {
        RUNNING,
        PRE_SUSPEND,
        SUSPENDING,
        SUSPENDED;

    }
}

