/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.orbspecific.interposition.resources.arjuna;

import com.arjuna.ats.arjuna.coordinator.ActionStatus;
import com.arjuna.ats.arjuna.coordinator.TwoPhaseOutcome;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.internal.arjuna.thread.ThreadActionData;
import com.arjuna.ats.internal.jts.ORBManager;
import com.arjuna.ats.internal.jts.interposition.resources.arjuna.Interposition;
import com.arjuna.ats.internal.jts.interposition.resources.arjuna.ServerResource;
import com.arjuna.ats.internal.jts.orbspecific.interposition.ServerControl;
import com.arjuna.ats.internal.jts.orbspecific.interposition.coordinator.ServerTransaction;
import com.arjuna.ats.jts.logging.jtsLogger;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.ResourceHelper;
import org.omg.CosTransactions.ResourceOperations;
import org.omg.CosTransactions.ResourcePOATie;
import org.omg.CosTransactions.Vote;

public class ServerTopLevelAction
extends ServerResource
implements ResourceOperations {
    protected ResourcePOATie _theResource;
    protected Resource _resourceRef;
    private boolean transactionInactive;

    public ServerTopLevelAction(ServerControl control) {
        super(control);
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("ServerTopLevelAction::ServerTopLevelAction ( " + this._theUid + " )"));
        }
        this._theResource = null;
        this._resourceRef = this.getReference();
        if (this._resourceRef != null) {
            Coordinator realCoordinator = this._theControl.originalCoordinator();
            this._valid = this.registerResource(realCoordinator);
            if (!this._valid) {
                // empty if block
            }
            Object var2_2 = null;
        } else {
            this._valid = false;
        }
    }

    public Resource getReference() {
        if (this._resourceRef == null && this._valid) {
            if (this._theControl != null) {
                this._theResource = new ResourcePOATie(this);
                ORBManager.getPOA().objectIsReady(this._theResource);
                this._resourceRef = ResourceHelper.narrow(ORBManager.getPOA().corbaReference(this._theResource));
            } else {
                this._valid = false;
            }
        }
        return this._resourceRef;
    }

    @Override
    public Vote prepare() throws HeuristicMixed, HeuristicHazard, SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("ServerTopLevelAction::prepare for " + this._theUid));
        }
        if (this._theControl == null) {
            throw new INVALID_TRANSACTION(70002, CompletionStatus.COMPLETED_NO);
        }
        if (this._theControl.isWrapper()) {
            this.destroyResource();
            return Vote.VoteReadOnly;
        }
        ServerTransaction theTransaction = (ServerTransaction)this._theControl.getImplHandle();
        int result = 1;
        int s = theTransaction.status();
        if (s == 0 || s == 3) {
            result = theTransaction.doPrepare();
        } else {
            switch (s) {
                case 6: 
                case 7: 
                case 12: {
                    result = 0;
                    break;
                }
                case 13: {
                    result = 5;
                    break;
                }
                case 14: {
                    result = 6;
                }
            }
        }
        ThreadActionData.popAction();
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("ServerTopLevelAction::prepare for " + this._theUid + " : " + TwoPhaseOutcome.stringForm(result)));
        }
        if (result == 1) {
            try {
                this.rollback();
            }
            catch (HeuristicCommit ex1) {
                result = 4;
            }
            catch (HeuristicMixed ex2) {
                result = 5;
            }
            catch (HeuristicHazard ex3) {
                result = 6;
            }
            catch (SystemException ex4) {
                result = 6;
            }
        }
        switch (result) {
            case 11: {
                throw new INVALID_TRANSACTION(60007, CompletionStatus.COMPLETED_NO);
            }
            case 0: {
                return Vote.VoteCommit;
            }
            case 1: {
                this.destroyResource();
                return Vote.VoteRollback;
            }
            case 2: {
                this.destroyResource();
                return Vote.VoteReadOnly;
            }
            case 5: {
                if (TxControl.getMaintainHeuristics()) {
                    this.destroyResource();
                }
                throw new HeuristicMixed();
            }
        }
        if (TxControl.getMaintainHeuristics()) {
            this.destroyResource();
        }
        throw new HeuristicHazard();
    }

    @Override
    public void rollback() throws HeuristicCommit, HeuristicMixed, HeuristicHazard, SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("ServerTopLevelAction::rollback for " + this._theUid));
        }
        if (this._theControl == null) {
            throw new INVALID_TRANSACTION(70002, CompletionStatus.COMPLETED_NO);
        }
        if (this._theControl.isWrapper()) {
            this.destroyResource();
            return;
        }
        ServerTransaction theTransaction = (ServerTransaction)this._theControl.getImplHandle();
        ThreadActionData.pushAction(theTransaction);
        int actionStatus = theTransaction.status();
        if (actionStatus == 5) {
            actionStatus = theTransaction.doPhase2Abort();
        } else if (actionStatus == 0 || actionStatus == 3) {
            try {
                if (!this.valid()) {
                    theTransaction.doPhase2Abort();
                } else {
                    theTransaction.rollback();
                }
                actionStatus = 4;
            }
            catch (SystemException ex) {
                actionStatus = 4;
                throw ex;
            }
            finally {
                this.destroyResource();
            }
        }
        ThreadActionData.popAction();
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("ServerTopLevelAction::rollback for " + this._theUid + " : " + ActionStatus.stringForm(actionStatus)));
        }
        switch (actionStatus) {
            case 5: {
                throw new INVALID_TRANSACTION(60007, CompletionStatus.COMPLETED_NO);
            }
            case 4: 
            case 11: {
                this.destroyResource();
                break;
            }
            case 7: 
            case 12: {
                this.destroyResource();
                throw new HeuristicCommit();
            }
            case 13: {
                if (TxControl.getMaintainHeuristics()) {
                    this.destroyResource();
                }
                throw new HeuristicMixed();
            }
            case 14: {
                if (TxControl.getMaintainHeuristics()) {
                    this.destroyResource();
                }
                throw new HeuristicHazard();
            }
            default: {
                this.destroyResource();
            }
        }
    }

    @Override
    public void commit() throws NotPrepared, HeuristicRollback, HeuristicMixed, HeuristicHazard, SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("ServerTopLevelAction::commit for " + this._theUid));
        }
        if (this._theControl == null) {
            throw new INVALID_TRANSACTION(70002, CompletionStatus.COMPLETED_NO);
        }
        if (this._theControl.isWrapper()) {
            this.destroyResource();
            return;
        }
        ServerTransaction theTransaction = (ServerTransaction)this._theControl.getImplHandle();
        ThreadActionData.pushAction(theTransaction);
        int actionStatus = theTransaction.status();
        boolean notPrepared = false;
        if (actionStatus == 5) {
            actionStatus = theTransaction.doPhase2Commit();
        } else if (actionStatus == 0) {
            if (jtsLogger.logger.isTraceEnabled()) {
                jtsLogger.logger.trace((Object)("ServerTopLevelAction::commit for " + this._theUid + " : NotPrepared"));
            }
            notPrepared = true;
        }
        ThreadActionData.popAction();
        if (notPrepared) {
            throw new NotPrepared();
        }
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("ServerTopLevelAction::commit for " + this._theUid + " : " + ActionStatus.stringForm(actionStatus)));
        }
        switch (actionStatus) {
            case 5: {
                throw new INVALID_TRANSACTION(70002, CompletionStatus.COMPLETED_NO);
            }
            case 7: 
            case 12: {
                this.destroyResource();
                break;
            }
            case 4: 
            case 11: {
                if (TxControl.getMaintainHeuristics()) {
                    this.destroyResource();
                }
                throw new HeuristicRollback();
            }
            case 13: {
                if (TxControl.getMaintainHeuristics()) {
                    this.destroyResource();
                }
                throw new HeuristicMixed();
            }
            case 14: {
                if (TxControl.getMaintainHeuristics()) {
                    this.destroyResource();
                }
                throw new HeuristicHazard();
            }
            default: {
                this.destroyResource();
            }
        }
    }

    @Override
    public void forget() throws SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("ServerTopLevelAction::forget for " + this._theUid));
        }
        boolean forgot = true;
        if (this._theControl != null) {
            forgot = this._theControl.forgetHeuristics();
        }
        this.destroyResource();
        if (!forgot) {
            throw new BAD_OPERATION();
        }
    }

    @Override
    public void commit_one_phase() throws HeuristicHazard, SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("ServerTopLevelAction::commit_one_phase for " + this._theUid));
        }
        if (this._theControl == null) {
            throw new INVALID_TRANSACTION(70002, CompletionStatus.COMPLETED_NO);
        }
        if (this._theControl.isWrapper()) {
            this.destroyResource();
            return;
        }
        ServerTransaction theTransaction = (ServerTransaction)this._theControl.getImplHandle();
        if (theTransaction == null) {
            jtsLogger.i18NLogger.warn_orbspecific_interposition_resources_arjuna_notx("ServerTopLevelAction.commit_one_phase");
            throw new INVALID_TRANSACTION(40005, CompletionStatus.COMPLETED_NO);
        }
        ThreadActionData.pushAction(theTransaction);
        try {
            theTransaction.doCommit(true);
        }
        catch (HeuristicHazard e1) {
            ThreadActionData.popAction();
            throw e1;
        }
        catch (TRANSACTION_ROLLEDBACK e4) {
            ThreadActionData.popAction();
            throw e4;
        }
        catch (INVALID_TRANSACTION e5) {
            ThreadActionData.popAction();
            throw e5;
        }
        catch (SystemException e6) {
            ThreadActionData.popAction();
            throw e6;
        }
        catch (Exception e7) {
            ThreadActionData.popAction();
            throw new UNKNOWN(e7.toString());
        }
        finally {
            this.destroyResource();
        }
        ThreadActionData.popAction();
        this.destroyResource();
    }

    public String type() {
        return "/Resources/Arjuna/ServerTopLevelAction";
    }

    protected ServerTopLevelAction() {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"ServerTopLevelAction::ServerTopLevelAction ()");
        }
        this._theResource = null;
        this._resourceRef = null;
    }

    protected synchronized void destroyResource() {
        if (!this._destroyed) {
            try {
                if (Interposition.destroy(this.get_uid())) {
                    this._destroyed = true;
                }
            }
            catch (Exception e) {
                jtsLogger.i18NLogger.warn_orbspecific_interposition_resources_arjuna_generror("ServerTopLevelAction.destroyResource", e);
            }
            try {
                if (this._theResource != null) {
                    ORBManager.getPOA().shutdownObject(this._theResource);
                    this._theResource = null;
                }
            }
            catch (Exception e) {
                jtsLogger.i18NLogger.warn_orbspecific_interposition_resources_arjuna_generror("ServerTopLevelAction.destroyResource", e);
            }
        }
        this.tidyup();
    }

    protected boolean registerResource(Coordinator theCoordinator) {
        boolean result;
        block11: {
            result = false;
            if (theCoordinator != null) {
                try {
                    RecoveryCoordinator recoveryCoord = theCoordinator.register_resource(this._resourceRef);
                    if (!this._theControl.isWrapper()) {
                        ServerTransaction tx2 = (ServerTransaction)this._theControl.getImplHandle();
                        if (tx2 != null) {
                            tx2.setRecoveryCoordinator(recoveryCoord);
                            result = true;
                        } else {
                            result = false;
                            jtsLogger.i18NLogger.warn_orbspecific_interposition_resources_arjuna_ipfailed("ServerTopLevelAction");
                        }
                        break block11;
                    }
                    result = true;
                }
                catch (ClassCastException classCastException) {
                    jtsLogger.i18NLogger.warn_orbspecific_interposition_resources_arjuna_generror("ServerTopLevelAction.registerResource", classCastException);
                }
                catch (Inactive ine) {
                    jtsLogger.i18NLogger.warn_server_top_level_action_inactive();
                    jtsLogger.i18NLogger.debug_orbspecific_interposition_resources_arjuna_generror("ServerTopLevelAction.registerResource", (Throwable)((Object)ine));
                    this.transactionInactive = true;
                }
                catch (TRANSACTION_ROLLEDBACK ex1) {
                    jtsLogger.i18NLogger.warn_orbspecific_interposition_resources_arjuna_generror("ServerTopLevelAction.registerResource", ex1);
                }
                catch (INVALID_TRANSACTION ex2) {
                    jtsLogger.i18NLogger.warn_orbspecific_interposition_resources_arjuna_generror("ServerTopLevelAction.registerResource", ex2);
                }
                catch (Exception e) {
                    jtsLogger.i18NLogger.warn_orbspecific_interposition_resources_arjuna_generror("ServerTopLevelAction.registerResource", e);
                }
            } else {
                jtsLogger.i18NLogger.warn_orbspecific_interposition_resources_arjuna_nocoord("ServerTopLevelAction.registerResource");
            }
        }
        return result;
    }

    public boolean isTransactionInactive() {
        return this.transactionInactive;
    }
}

