/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.component.serialization.WriteReplaceInterface;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.deployment.ApplicableMethodInformation;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.security.AuthorizationInterceptor;
import org.jboss.as.ejb3.security.EJBMethodSecurityAttribute;
import org.jboss.as.ejb3.security.SecurityContextInterceptorFactory;
import org.jboss.as.ejb3.security.service.EJBViewMethodSecurityAttributesService;
import org.jboss.as.security.deployment.SecurityAttachments;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;

public class EJBSecurityViewConfigurator
implements ViewConfigurator {
    public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription viewDescription, ViewConfiguration viewConfiguration) throws DeploymentUnitProcessingException {
        ServiceName viewMethodSecurityAttributesServiceName;
        EJBViewMethodSecurityAttributesService.Builder viewMethodSecurityAttributesServiceBuilder;
        if (!(componentConfiguration.getComponentDescription() instanceof EJBComponentDescription)) {
            throw EjbLogger.ROOT_LOGGER.invalidEjbComponent(componentConfiguration.getComponentName(), componentConfiguration.getComponentClass());
        }
        if (!context.getDeploymentUnit().hasAttachment(SecurityAttachments.SECURITY_ENABLED)) {
            return;
        }
        DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)context.getDeploymentUnit().getAttachment(Attachments.REFLECTION_INDEX);
        EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentConfiguration.getComponentDescription();
        if (ejbComponentDescription.getSecurityDomain() == null || ejbComponentDescription.getSecurityDomain().isEmpty()) {
            if (EjbLogger.ROOT_LOGGER.isDebugEnabled()) {
                EjbLogger.ROOT_LOGGER.debug("Security is *not* enabled on EJB: " + ejbComponentDescription.getEJBName() + ", since no explicit security domain is configured for the bean, nor is there any default security domain configured in the EJB3 subsystem");
            }
            return;
        }
        String viewClassName = viewDescription.getViewClassName();
        EJBViewDescription ejbViewDescription = (EJBViewDescription)viewDescription;
        String contextID = SecurityContextInterceptorFactory.contextIdForDeployment(context.getDeploymentUnit());
        if (ejbComponentDescription instanceof SessionBeanComponentDescription && MethodIntf.SERVICE_ENDPOINT == ejbViewDescription.getMethodIntf() && ((SessionBeanComponentDescription)ejbComponentDescription).hasNoInterfaceView()) {
            viewMethodSecurityAttributesServiceBuilder = null;
            viewMethodSecurityAttributesServiceName = null;
        } else {
            viewMethodSecurityAttributesServiceBuilder = new EJBViewMethodSecurityAttributesService.Builder();
            viewMethodSecurityAttributesServiceName = EJBViewMethodSecurityAttributesService.getServiceName(ejbComponentDescription.getApplicationName(), ejbComponentDescription.getModuleName(), ejbComponentDescription.getEJBName(), viewClassName);
        }
        boolean beanHasMethodLevelSecurityMetadata = false;
        List viewMethods = viewConfiguration.getProxyFactory().getCachedMethods();
        ArrayList<Method> methodsWithoutExplicitSecurityConfiguration = new ArrayList<Method>();
        for (Method viewMethod : viewMethods) {
            if (!Modifier.isPublic(viewMethod.getModifiers()) || viewMethod.getDeclaringClass() == WriteReplaceInterface.class) continue;
            ApplicableMethodInformation<EJBMethodSecurityAttribute> permissions = ejbComponentDescription.getDescriptorMethodPermissions();
            boolean methodHasSecurityMetadata = this.handlePermissions(contextID, componentConfiguration, viewConfiguration, deploymentReflectionIndex, viewClassName, ejbViewDescription, viewMethod, permissions, false, viewMethodSecurityAttributesServiceBuilder);
            if (!methodHasSecurityMetadata) {
                methodHasSecurityMetadata = this.handlePermissions(contextID, componentConfiguration, viewConfiguration, deploymentReflectionIndex, viewClassName, ejbViewDescription, viewMethod, ejbComponentDescription.getAnnotationMethodPermissions(), true, viewMethodSecurityAttributesServiceBuilder);
            }
            if (methodHasSecurityMetadata) {
                beanHasMethodLevelSecurityMetadata = true;
                continue;
            }
            methodsWithoutExplicitSecurityConfiguration.add(viewMethod);
        }
        boolean securityRequired = beanHasMethodLevelSecurityMetadata || ejbComponentDescription.hasBeanLevelSecurityMetadata();
        viewConfiguration.addViewInterceptor((InterceptorFactory)new SecurityContextInterceptorFactory(securityRequired, true, contextID), 592);
        if (securityRequired) {
            Boolean denyAccessToMethodsMissingPermissions = ((EJBComponentDescription)componentConfiguration.getComponentDescription()).isMissingMethodPermissionsDeniedAccess();
            if (denyAccessToMethodsMissingPermissions == null || denyAccessToMethodsMissingPermissions.booleanValue()) {
                for (Method viewMethod : methodsWithoutExplicitSecurityConfiguration) {
                    if (viewMethodSecurityAttributesServiceBuilder != null) {
                        viewMethodSecurityAttributesServiceBuilder.addMethodSecurityMetadata(viewMethod, EJBMethodSecurityAttribute.denyAll());
                    }
                    AuthorizationInterceptor authorizationInterceptor = new AuthorizationInterceptor(EJBMethodSecurityAttribute.denyAll(), viewClassName, viewMethod, contextID);
                    viewConfiguration.addViewInterceptor(viewMethod, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)authorizationInterceptor), 768);
                }
            }
            if (viewMethodSecurityAttributesServiceBuilder != null) {
                EJBViewMethodSecurityAttributesService viewMethodSecurityAttributesService = viewMethodSecurityAttributesServiceBuilder.build();
                context.getServiceTarget().addService(viewMethodSecurityAttributesServiceName, (Service)viewMethodSecurityAttributesService).install();
            }
        } else {
            EjbLogger.ROOT_LOGGER.debugf("Security is *not* enabled on EJB: %s, no security interceptors will apply", ejbComponentDescription.getEJBName());
            if (viewMethodSecurityAttributesServiceBuilder != null) {
                EJBViewMethodSecurityAttributesService viewMethodSecurityAttributesService = viewMethodSecurityAttributesServiceBuilder.build();
                context.getServiceTarget().addService(viewMethodSecurityAttributesServiceName, (Service)viewMethodSecurityAttributesService).install();
            }
            return;
        }
    }

    private boolean handlePermissions(String contextID, ComponentConfiguration componentConfiguration, ViewConfiguration viewConfiguration, DeploymentReflectionIndex deploymentReflectionIndex, String viewClassName, EJBViewDescription ejbViewDescription, Method viewMethod, ApplicableMethodInformation<EJBMethodSecurityAttribute> permissions, boolean annotations, EJBViewMethodSecurityAttributesService.Builder viewMethodSecurityAttributesServiceBuilder) {
        EJBMethodSecurityAttribute ejbMethodSecurityMetaData = permissions.getViewAttribute(ejbViewDescription.getMethodIntf(), viewMethod);
        ArrayList<EJBMethodSecurityAttribute> allAttributes = new ArrayList<EJBMethodSecurityAttribute>();
        allAttributes.addAll(permissions.getAllAttributes(ejbViewDescription.getMethodIntf(), viewMethod));
        if (ejbMethodSecurityMetaData == null) {
            ejbMethodSecurityMetaData = permissions.getViewAttribute(MethodIntf.BEAN, viewMethod);
        }
        allAttributes.addAll(permissions.getAllAttributes(MethodIntf.BEAN, viewMethod));
        Method classMethod = ClassReflectionIndexUtil.findMethod((DeploymentReflectionIndex)deploymentReflectionIndex, (Class)componentConfiguration.getComponentClass(), (Method)viewMethod);
        if (ejbMethodSecurityMetaData == null && classMethod != null && (ejbMethodSecurityMetaData = permissions.getAttribute(ejbViewDescription.getMethodIntf(), classMethod)) == null) {
            ejbMethodSecurityMetaData = permissions.getAttribute(MethodIntf.BEAN, classMethod);
        }
        if (classMethod != null) {
            allAttributes.addAll(permissions.getAllAttributes(ejbViewDescription.getMethodIntf(), classMethod));
            allAttributes.addAll(permissions.getAllAttributes(MethodIntf.BEAN, classMethod));
        }
        if (ejbMethodSecurityMetaData != null) {
            if (!(annotations || ejbMethodSecurityMetaData.isDenyAll() || ejbMethodSecurityMetaData.isPermitAll())) {
                HashSet<String> rolesAllowed = new HashSet<String>();
                for (EJBMethodSecurityAttribute attr : allAttributes) {
                    rolesAllowed.addAll(attr.getRolesAllowed());
                }
                ejbMethodSecurityMetaData = EJBMethodSecurityAttribute.rolesAllowed(rolesAllowed);
            }
            viewMethodSecurityAttributesServiceBuilder.addMethodSecurityMetadata(viewMethod, ejbMethodSecurityMetaData);
            AuthorizationInterceptor authorizationInterceptor = new AuthorizationInterceptor(ejbMethodSecurityMetaData, viewClassName, viewMethod, contextID);
            viewConfiguration.addViewInterceptor(viewMethod, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)authorizationInterceptor), 768);
            return true;
        }
        return false;
    }
}

