/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.servlets;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jboss.logging.Logger;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.TrustKeyConfigurationException;
import org.picketlink.common.exceptions.TrustKeyProcessingException;
import org.picketlink.common.exceptions.fed.IssueInstantMissingException;
import org.picketlink.common.exceptions.fed.IssuerNotTrustedException;
import org.picketlink.common.util.StringUtil;
import org.picketlink.config.federation.AuthPropertyType;
import org.picketlink.config.federation.IDPType;
import org.picketlink.config.federation.KeyProviderType;
import org.picketlink.config.federation.PicketLinkType;
import org.picketlink.config.federation.handler.Handlers;
import org.picketlink.identity.federation.core.impl.DelegatedAttributeManager;
import org.picketlink.identity.federation.core.interfaces.AttributeManager;
import org.picketlink.identity.federation.core.interfaces.RoleGenerator;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.picketlink.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerChain;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerChainConfig;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerResponse;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChain;
import org.picketlink.identity.federation.core.saml.v2.util.HandlerUtil;
import org.picketlink.identity.federation.core.sts.PicketLinkCoreSTS;
import org.picketlink.identity.federation.core.util.CoreConfigUtil;
import org.picketlink.identity.federation.core.util.XMLSignatureUtil;
import org.picketlink.identity.federation.saml.v2.SAML2Object;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.core.IdentityParticipantStack;
import org.picketlink.identity.federation.web.core.IdentityServer;
import org.picketlink.identity.federation.web.roles.DefaultRoleGenerator;
import org.picketlink.identity.federation.web.servlets.SecurityActions;
import org.picketlink.identity.federation.web.util.ConfigurationUtil;
import org.picketlink.identity.federation.web.util.IDPWebRequestUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingSignatureUtil;
import org.picketlink.identity.federation.web.util.SAMLConfigurationProvider;
import org.w3c.dom.Document;

public class IDPServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(IDPServlet.class);
    private final boolean trace = log.isTraceEnabled();
    protected transient IDPType idpConfiguration = null;
    protected transient PicketLinkType picketLinkConfiguration = null;
    protected transient RoleGenerator roleGenerator = new DefaultRoleGenerator();
    protected transient DelegatedAttributeManager attribManager;
    protected List<String> attributeKeys = new ArrayList<String>();
    protected String identityURL = null;
    protected transient TrustKeyManager keyManager;
    protected Boolean ignoreIncomingSignatures = false;
    protected Boolean signOutgoingMessages = true;
    protected String canonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    protected transient ServletContext context = null;
    protected transient SAML2HandlerChain chain = null;
    private boolean strictPostBinding = false;
    protected String identityParticipantStack = null;

    public boolean isStrictPostBinding() {
        return this.strictPostBinding;
    }

    public void setStrictPostBinding(boolean strictPostBinding) {
        this.strictPostBinding = strictPostBinding;
    }

    public Boolean getIgnoreIncomingSignatures() {
        return this.ignoreIncomingSignatures;
    }

    public void init(ServletConfig config) throws ServletException {
        File stsConfigFile;
        IdentityServer identityServer;
        String rgString;
        String strictPostBindingStr;
        Handlers handlers = null;
        super.init(config);
        String configFile = "/WEB-INF/picketlink.xml";
        String configProviderStr = config.getInitParameter("CONFIG_PROVIDER");
        if (StringUtil.isNotNull((String)configProviderStr)) {
            Class<?> clazz = SecurityActions.loadClass(((Object)((Object)this)).getClass(), configProviderStr);
            if (clazz == null) {
                throw new RuntimeException("PL00085: Class Not Loaded:" + configProviderStr);
            }
            try {
                this.idpConfiguration = ((SAMLConfigurationProvider)clazz.newInstance()).getIDPConfiguration();
            }
            catch (Exception e) {
                throw new RuntimeException("PL00102: Processing Exception:", e);
            }
        }
        if (StringUtil.isNotNull((String)(strictPostBindingStr = config.getInitParameter("SAML_IDP_STRICT_POST_BINDING")))) {
            this.strictPostBinding = Boolean.parseBoolean(strictPostBindingStr);
        }
        this.context = config.getServletContext();
        if (this.idpConfiguration == null) {
            InputStream is = this.context.getResourceAsStream(configFile);
            if (is != null) {
                try {
                    this.picketLinkConfiguration = ConfigurationUtil.getConfiguration(is);
                    this.idpConfiguration = (IDPType)this.picketLinkConfiguration.getIdpOrSP();
                }
                catch (ParsingException e) {
                    throw new RuntimeException("PL00102: Processing Exception:", e);
                }
            }
            is = this.context.getResourceAsStream("/WEB-INF/picketlink-idfed.xml");
            if (is == null) {
                throw new RuntimeException("PL00025: Service Provider:: Configuration File missing:" + configFile + " missing");
            }
            try {
                this.idpConfiguration = ConfigurationUtil.getIDPConfiguration(is);
            }
            catch (ParsingException e) {
                throw new RuntimeException("PL00102: Processing Exception:", e);
            }
        }
        this.chain = new DefaultSAML2HandlerChain();
        try {
            String attributeManager;
            this.identityURL = this.idpConfiguration.getIdentityURL();
            log.trace((Object)("Identity Provider URL=" + this.identityURL));
            this.canonicalizationMethod = this.idpConfiguration.getCanonicalizationMethod();
            log.info((Object)("IDPServlet:: Setting the CanonicalizationMethod on XMLSignatureUtil::" + this.canonicalizationMethod));
            XMLSignatureUtil.setCanonicalizationMethodType(this.canonicalizationMethod);
            String attribList = config.getInitParameter("ATTRIBUTE_KEYS");
            if (StringUtil.isNotNull((String)attribList)) {
                this.attributeKeys.addAll(StringUtil.tokenize((String)attribList));
            }
            if ((attributeManager = this.idpConfiguration.getAttributeManager()) != null && !"".equals(attributeManager)) {
                AttributeManager delegate = (AttributeManager)SecurityActions.loadClass(((Object)((Object)this)).getClass(), attributeManager).newInstance();
                this.attribManager = new DelegatedAttributeManager(delegate, this.attributeKeys);
            }
            String handlerConfigFileName = "/WEB-INF/picketlink-handlers.xml";
            handlers = this.picketLinkConfiguration != null ? this.picketLinkConfiguration.getHandlers() : ConfigurationUtil.getHandlers(this.context.getResourceAsStream(handlerConfigFileName));
            this.chain.addAll(HandlerUtil.getHandlers(handlers));
            HashMap<String, Object> chainConfigOptions = new HashMap<String, Object>();
            chainConfigOptions.put("ROLE_GENERATOR", this.roleGenerator);
            chainConfigOptions.put("CONFIGURATION", this.idpConfiguration);
            DefaultSAML2HandlerChainConfig handlerChainConfig = new DefaultSAML2HandlerChainConfig(chainConfigOptions);
            Set<SAML2Handler> samlHandlers = this.chain.handlers();
            for (SAML2Handler handler : samlHandlers) {
                handler.initChainConfig(handlerChainConfig);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String signOutgoingString = config.getInitParameter("SIGN_OUTGOING_MESSAGES");
        if (signOutgoingString != null && !"".equals(signOutgoingString)) {
            this.signOutgoingMessages = Boolean.parseBoolean(signOutgoingString);
        }
        if (this.signOutgoingMessages.booleanValue()) {
            KeyProviderType keyProvider = this.idpConfiguration.getKeyProvider();
            if (keyProvider == null) {
                throw new RuntimeException("PL00092: Null Value:Key Provider is null for context=" + this.context.getContextPath());
            }
            try {
                String keyManagerClassName = keyProvider.getClassName();
                if (keyManagerClassName == null) {
                    throw new RuntimeException("PL00092: Null Value:KeyManager class name is null");
                }
                Class<?> clazz = SecurityActions.loadClass(((Object)((Object)this)).getClass(), keyManagerClassName);
                this.keyManager = (TrustKeyManager)clazz.newInstance();
                List<AuthPropertyType> authProperties = CoreConfigUtil.getKeyProviderProperties(keyProvider);
                this.keyManager.setAuthProperties(authProperties);
                this.keyManager.setValidatingAlias(keyProvider.getValidatingAlias());
            }
            catch (Exception e) {
                log.error((Object)"Exception reading configuration:", (Throwable)e);
                throw new RuntimeException(e.getLocalizedMessage());
            }
            if (this.trace) {
                log.trace((Object)("Key Provider=" + keyProvider.getClassName()));
            }
        }
        if ((rgString = config.getInitParameter("ROLE_GENERATOR")) != null && !"".equals(rgString)) {
            this.setRoleGenerator(rgString);
        }
        if ((identityServer = (IdentityServer)this.context.getAttribute("IDENTITY_SERVER")) == null) {
            identityServer = new IdentityServer();
            this.context.setAttribute("IDENTITY_SERVER", (Object)identityServer);
            String theStackParam = config.getInitParameter("IDENTITY_PARTICIPANT_STACK");
            if (StringUtil.isNotNull((String)theStackParam)) {
                try {
                    Class<?> stackClass = SecurityActions.loadClass(((Object)((Object)this)).getClass(), theStackParam);
                    identityServer.setStack((IdentityParticipantStack)stackClass.newInstance());
                }
                catch (Exception e) {
                    this.log("Unable to set the Identity Participant Stack Class. Will just use the default", e);
                }
            }
        }
        PicketLinkCoreSTS sts = PicketLinkCoreSTS.instance();
        String configPath = this.context.getRealPath("/WEB-INF/picketlink-sts.xml");
        File file = stsConfigFile = configPath != null ? new File(configPath) : null;
        if (stsConfigFile == null || !stsConfigFile.exists()) {
            sts.installDefaultConfiguration(new String[0]);
        } else {
            sts.installDefaultConfiguration(configPath);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession(false);
        String samlRequestMessage = (String)session.getAttribute("SAMLRequest");
        String samlResponseMessage = (String)session.getAttribute("SAMLResponse");
        String relayState = (String)session.getAttribute("RelayState");
        String referer = request.getHeader("Referer");
        Principal userPrincipal = (Principal)session.getAttribute("picketlink.principal");
        if (userPrincipal == null) {
            if (this.trace) {
                log.trace((Object)"Login Filters have not been configured");
            }
            response.sendError(500);
        }
        IDPWebRequestUtil webRequestUtil = new IDPWebRequestUtil(request, this.idpConfiguration, this.keyManager);
        webRequestUtil.setCanonicalizationMethod(this.canonicalizationMethod);
        boolean willSendRequest = true;
        if (userPrincipal != null) {
            block46: {
                Document samlResponse;
                String destination;
                block45: {
                    if (this.trace) {
                        log.trace((Object)"Retrieved saml message and relay state from session");
                        log.trace((Object)("saml Request message=" + samlRequestMessage + "::relay state=" + relayState));
                        log.trace((Object)("saml Response message=" + samlResponseMessage + "::relay state=" + relayState));
                    }
                    session.removeAttribute("SAMLRequest");
                    session.removeAttribute("SAMLResponse");
                    if (StringUtil.isNotNull((String)relayState)) {
                        session.removeAttribute("RelayState");
                    }
                    SAMLDocumentHolder samlDocumentHolder = null;
                    SAML2Object samlObject = null;
                    destination = null;
                    samlResponse = null;
                    if (samlResponseMessage != null) {
                        StatusResponseType statusResponseType = null;
                        try {
                            samlDocumentHolder = webRequestUtil.getSAMLDocumentHolder(samlResponseMessage);
                            samlObject = samlDocumentHolder.getSamlObject();
                            boolean isPost = webRequestUtil.hasSAMLRequestInPostProfile();
                            boolean isValid = this.validate(request.getRemoteAddr(), request.getQueryString(), new SessionHolder(samlResponseMessage, null), isPost);
                            if (!isValid) {
                                throw new GeneralSecurityException("Validation check failed");
                            }
                            String issuer = null;
                            IssuerInfoHolder idpIssuer = new IssuerInfoHolder(this.identityURL);
                            HTTPContext protocolContext = new HTTPContext(request, response, this.context);
                            DefaultSAML2HandlerRequest saml2HandlerRequest = new DefaultSAML2HandlerRequest(protocolContext, idpIssuer.getIssuer(), samlDocumentHolder, SAML2Handler.HANDLER_TYPE.IDP);
                            saml2HandlerRequest.setRelayState(relayState);
                            DefaultSAML2HandlerResponse saml2HandlerResponse = new DefaultSAML2HandlerResponse();
                            Set<SAML2Handler> handlers = this.chain.handlers();
                            if (samlObject instanceof StatusResponseType) {
                                statusResponseType = (StatusResponseType)samlObject;
                                issuer = statusResponseType.getIssuer().getValue();
                                webRequestUtil.isTrusted(issuer);
                                if (handlers != null) {
                                    for (SAML2Handler handler : handlers) {
                                        handler.reset();
                                        handler.handleStatusResponseType(saml2HandlerRequest, saml2HandlerResponse);
                                        willSendRequest = saml2HandlerResponse.getSendRequest();
                                    }
                                }
                            } else {
                                throw new RuntimeException("PL00069: Parser: Type not supported:Unknown type:" + samlObject.getClass().getName());
                            }
                            samlResponse = saml2HandlerResponse.getResultingDocument();
                            relayState = saml2HandlerResponse.getRelayState();
                            destination = saml2HandlerResponse.getDestination();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (samlRequestMessage != null) {
                        RequestAbstractType requestAbstractType = null;
                        try {
                            List<String> roles;
                            samlDocumentHolder = webRequestUtil.getSAMLDocumentHolder(samlRequestMessage);
                            samlObject = samlDocumentHolder.getSamlObject();
                            boolean isPost = webRequestUtil.hasSAMLRequestInPostProfile();
                            boolean isValid = this.validate(request.getRemoteAddr(), request.getQueryString(), new SessionHolder(samlRequestMessage, null), isPost);
                            if (!isValid) {
                                throw new GeneralSecurityException("PL00019: Validation check failedValidation check failed");
                            }
                            String issuer = null;
                            IssuerInfoHolder idpIssuer = new IssuerInfoHolder(this.identityURL);
                            HTTPContext protocolContext = new HTTPContext(request, response, this.context);
                            DefaultSAML2HandlerRequest saml2HandlerRequest = new DefaultSAML2HandlerRequest(protocolContext, idpIssuer.getIssuer(), samlDocumentHolder, SAML2Handler.HANDLER_TYPE.IDP);
                            saml2HandlerRequest.setRelayState(relayState);
                            HashMap<String, Object> requestOptions = new HashMap<String, Object>();
                            if (requestAbstractType instanceof AuthnRequestType) {
                                roles = this.roleGenerator.generateRoles(userPrincipal);
                                session.setAttribute("picketlink.roles", roles);
                                Set<AttributeStatementType> attribs = this.attribManager.getAttributes((AuthnRequestType)requestAbstractType, userPrincipal);
                                requestOptions.put("ATTRIBUTES", attribs);
                            }
                            requestOptions.put("CONFIGURATION", this.idpConfiguration);
                            saml2HandlerRequest.setOptions(requestOptions);
                            roles = (List<String>)session.getAttribute("picketlink.roles");
                            if (roles == null) {
                                roles = this.roleGenerator.generateRoles(userPrincipal);
                                session.setAttribute("picketlink.roles", roles);
                            }
                            DefaultSAML2HandlerResponse saml2HandlerResponse = new DefaultSAML2HandlerResponse();
                            Set<SAML2Handler> handlers = this.chain.handlers();
                            if (samlObject instanceof RequestAbstractType) {
                                requestAbstractType = (RequestAbstractType)samlObject;
                                issuer = requestAbstractType.getIssuer().getValue();
                                webRequestUtil.isTrusted(issuer);
                                if (handlers != null) {
                                    for (SAML2Handler handler : handlers) {
                                        handler.handleRequestType(saml2HandlerRequest, saml2HandlerResponse);
                                        willSendRequest = saml2HandlerResponse.getSendRequest();
                                    }
                                }
                            } else {
                                throw new RuntimeException("PL00069: Parser: Type not supported:Unknown type:" + samlObject.getClass().getName());
                            }
                            samlResponse = saml2HandlerResponse.getResultingDocument();
                            relayState = saml2HandlerResponse.getRelayState();
                            destination = saml2HandlerResponse.getDestination();
                        }
                        catch (IssuerNotTrustedException e) {
                            if (this.trace) {
                                log.trace((Object)"Exception:", (Throwable)e);
                            }
                            samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_REQUEST_DENIED.get(), this.identityURL, this.signOutgoingMessages);
                        }
                        catch (ParsingException e) {
                            if (this.trace) {
                                log.trace((Object)"Exception:", (Throwable)e);
                            }
                            samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages);
                        }
                        catch (ConfigurationException e) {
                            if (this.trace) {
                                log.trace((Object)"Exception:", (Throwable)e);
                            }
                            samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages);
                        }
                        catch (IssueInstantMissingException e) {
                            if (this.trace) {
                                log.trace((Object)"Exception:", (Throwable)e);
                            }
                            samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages);
                        }
                        catch (GeneralSecurityException e) {
                            if (this.trace) {
                                log.trace((Object)"Security Exception:", (Throwable)e);
                            }
                            samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages);
                        }
                        catch (Exception e) {
                            if (this.trace) {
                                log.trace((Object)"Exception:", (Throwable)e);
                            }
                            samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages);
                        }
                    } else {
                        log.error((Object)"No SAML Request Message");
                        if (this.trace) {
                            log.trace((Object)("Referer=" + referer));
                        }
                        try {
                            this.sendErrorResponseToSP(referer, response, relayState, webRequestUtil);
                            return;
                        }
                        catch (ConfigurationException e) {
                            if (!this.trace) break block45;
                            log.trace((Object)e);
                        }
                    }
                }
                try {
                    if (samlResponse == null) {
                        throw new ServletException("PL00092: Null Value:SAML Response has not been generated");
                    }
                    IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                    holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setServletResponse(response);
                    holder.setPostBindingRequested(true);
                    if (this.signOutgoingMessages.booleanValue()) {
                        holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                    }
                    if (this.strictPostBinding) {
                        holder.setStrictPostBinding(this.strictPostBinding);
                    }
                    webRequestUtil.send(holder);
                }
                catch (ParsingException e) {
                    if (this.trace) {
                        log.trace((Object)e);
                    }
                }
                catch (GeneralSecurityException e) {
                    if (!this.trace) break block46;
                    log.trace((Object)e);
                }
            }
            return;
        }
    }

    protected void sendErrorResponseToSP(String referrer, HttpServletResponse response, String relayState, IDPWebRequestUtil webRequestUtil) throws ServletException, IOException, ConfigurationException {
        if (this.trace) {
            log.trace((Object)("About to send error response to SP:" + referrer));
        }
        Document samlResponse = webRequestUtil.getErrorResponse(referrer, JBossSAMLURIConstants.STATUS_RESPONDER.get(), this.identityURL, this.signOutgoingMessages);
        try {
            IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
            holder.setResponseDoc(samlResponse).setDestination(referrer).setRelayState(relayState).setAreWeSendingRequest(false).setPrivateKey(null).setSupportSignature(false).setServletResponse(response);
            holder.setPostBindingRequested(true);
            if (this.signOutgoingMessages.booleanValue()) {
                holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
            }
            if (this.strictPostBinding) {
                holder.setStrictPostBinding(true);
            }
            webRequestUtil.send(holder);
        }
        catch (ParsingException e1) {
            throw new ServletException((Throwable)e1);
        }
        catch (GeneralSecurityException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(405);
    }

    protected boolean validate(String remoteAddress, String queryString, SessionHolder holder, boolean isPost) throws IOException, GeneralSecurityException {
        if (holder.samlRequest == null || holder.samlRequest.length() == 0) {
            return false;
        }
        if (!this.ignoreIncomingSignatures.booleanValue() && !isPost) {
            PublicKey validatingKey;
            String sig = holder.signature;
            if (sig == null || sig.length() == 0) {
                log.error((Object)("Signature received from SP is null:" + remoteAddress));
                return false;
            }
            byte[] sigValue = RedirectBindingSignatureUtil.getSignatureValueFromSignedURL(queryString);
            if (sigValue == null) {
                return false;
            }
            try {
                validatingKey = this.keyManager.getValidatingKey(remoteAddress);
            }
            catch (TrustKeyConfigurationException e) {
                throw new GeneralSecurityException(e.getCause());
            }
            catch (TrustKeyProcessingException e) {
                throw new GeneralSecurityException(e.getCause());
            }
            return RedirectBindingSignatureUtil.validateSignature(queryString, validatingKey, sigValue);
        }
        return true;
    }

    public void testPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    private void setRoleGenerator(String rgName) {
        try {
            Class<?> clazz = SecurityActions.loadClass(((Object)((Object)this)).getClass(), rgName);
            this.roleGenerator = (RoleGenerator)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static class SessionHolder {
        String samlRequest;
        String signature;

        public SessionHolder(String req, String sig) {
            this.samlRequest = req;
            this.signature = sig;
        }
    }
}

