/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.reflection;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.jboss.weld.util.collections.Arrays2;

public class ParameterizedTypeImpl
implements ParameterizedType,
Serializable {
    private static final long serialVersionUID = -3005183010706452884L;
    private final Type[] actualTypeArguments;
    private final Type rawType;
    private final Type ownerType;

    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public ParameterizedTypeImpl(Type rawType, Type ... actualTypeArguments) {
        this(rawType, actualTypeArguments, (Type)null);
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public ParameterizedTypeImpl(Type rawType, Type[] actualTypeArguments, Type ownerType) {
        this.actualTypeArguments = actualTypeArguments;
        this.rawType = rawType;
        this.ownerType = ownerType;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return Arrays2.copyOf(this.actualTypeArguments, this.actualTypeArguments.length);
    }

    @Override
    public Type getOwnerType() {
        return this.ownerType;
    }

    @Override
    public Type getRawType() {
        return this.rawType;
    }

    public int hashCode() {
        return Arrays.hashCode(this.actualTypeArguments) ^ (this.ownerType == null ? 0 : this.ownerType.hashCode()) ^ (this.rawType == null ? 0 : this.rawType.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ParameterizedType) {
            ParameterizedType that = (ParameterizedType)obj;
            Type thatOwnerType = that.getOwnerType();
            Type thatRawType = that.getRawType();
            return (this.ownerType == null ? thatOwnerType == null : this.ownerType.equals(thatOwnerType)) && (this.rawType == null ? thatRawType == null : this.rawType.equals(thatRawType)) && Arrays.equals(this.actualTypeArguments, that.getActualTypeArguments());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.rawType);
        if (this.actualTypeArguments.length > 0) {
            sb.append("<");
            for (Type actualType : this.actualTypeArguments) {
                sb.append(actualType);
                sb.append(",");
            }
            sb.delete(sb.length() - 1, sb.length());
            sb.append(">");
        }
        return sb.toString();
    }
}

