/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.proton;

import java.util.UUID;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.protocol.proton.HornetQAMQPProtocolMessageBundle;
import org.hornetq.core.protocol.proton.ProtonDeliveryHandler;
import org.hornetq.core.protocol.proton.ProtonProtocolManager;
import org.hornetq.core.protocol.proton.ProtonRemotingConnection;
import org.hornetq.core.protocol.proton.ProtonSession;
import org.hornetq.core.protocol.proton.exceptions.HornetQAMQPException;
import org.hornetq.core.server.QueueQueryResult;

public class ProtonProducer
implements ProtonDeliveryHandler {
    private final ProtonRemotingConnection connection;
    private final ProtonSession protonSession;
    private final ProtonProtocolManager protonProtocolManager;
    private final Receiver receiver;
    private final String address;
    private HornetQBuffer buffer;

    public ProtonProducer(ProtonRemotingConnection connection, ProtonSession protonSession, ProtonProtocolManager protonProtocolManager, Receiver receiver) {
        this.connection = connection;
        this.protonSession = protonSession;
        this.protonProtocolManager = protonProtocolManager;
        this.receiver = receiver;
        this.address = ((Target)receiver.getRemoteTarget()).getAddress();
        this.buffer = connection.createTransportBuffer(1024);
    }

    @Override
    public void onMessage(Delivery delivery) throws HornetQAMQPException {
        try {
            Receiver receiver = (Receiver)delivery.getLink();
            if (!delivery.isReadable()) {
                return;
            }
            this.protonProtocolManager.handleMessage(receiver, this.buffer, delivery, this.connection, this.protonSession, this.address);
        }
        catch (Exception e) {
            e.printStackTrace();
            Rejected rejected = new Rejected();
            ErrorCondition condition = new ErrorCondition();
            condition.setCondition(Symbol.valueOf((String)"failed"));
            condition.setDescription(e.getMessage());
            rejected.setError(condition);
            delivery.disposition((DeliveryState)rejected);
        }
    }

    @Override
    public void checkState() {
    }

    @Override
    public void close() throws HornetQAMQPException {
        this.protonSession.removeProducer(this.receiver);
    }

    public void init() throws HornetQAMQPException {
        Target target = (Target)this.receiver.getRemoteTarget();
        if (target.getDynamic()) {
            SimpleString queue = new SimpleString(UUID.randomUUID().toString());
            try {
                this.protonSession.getServerSession().createQueue(queue, queue, null, true, false);
            }
            catch (Exception e) {
                throw HornetQAMQPProtocolMessageBundle.BUNDLE.errorCreatingTemporaryQueue(e.getMessage());
            }
            target.setAddress(queue.toString());
        } else {
            String address = target.getAddress();
            if (address == null) {
                throw HornetQAMQPProtocolMessageBundle.BUNDLE.targetAddressNotSet();
            }
            try {
                QueueQueryResult queryResult = this.protonSession.getServerSession().executeQueueQuery(new SimpleString(address));
                if (!queryResult.isExists()) {
                    throw HornetQAMQPProtocolMessageBundle.BUNDLE.addressDoesntExist();
                }
            }
            catch (Exception e) {
                throw HornetQAMQPProtocolMessageBundle.BUNDLE.errorFindingTemporaryQueue(e.getMessage());
            }
        }
    }
}

