/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.cfg.Configuration;
import org.hibernate.envers.internal.tools.Tools;
import org.hibernate.envers.internal.tools.graph.GraphDefiner;
import org.hibernate.mapping.PersistentClass;

public class PersistentClassGraphDefiner
implements GraphDefiner<PersistentClass, String> {
    private Configuration cfg;

    public PersistentClassGraphDefiner(Configuration cfg) {
        this.cfg = cfg;
    }

    @Override
    public String getRepresentation(PersistentClass pc) {
        return pc.getEntityName();
    }

    @Override
    public PersistentClass getValue(String entityName) {
        return this.cfg.getClassMapping(entityName);
    }

    private void addNeighbours(List<PersistentClass> neighbours, Iterator<PersistentClass> subclassIterator) {
        while (subclassIterator.hasNext()) {
            PersistentClass subclass = subclassIterator.next();
            neighbours.add(subclass);
            this.addNeighbours(neighbours, subclass.getSubclassIterator());
        }
    }

    @Override
    public List<PersistentClass> getNeighbours(PersistentClass pc) {
        ArrayList<PersistentClass> neighbours = new ArrayList<PersistentClass>();
        this.addNeighbours(neighbours, pc.getSubclassIterator());
        return neighbours;
    }

    @Override
    public List<PersistentClass> getValues() {
        return Tools.iteratorToList(this.cfg.getClassMappings());
    }
}

