/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexmanager;

import java.util.Properties;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.store.DirectoryProvider;
import org.infinispan.hibernate.search.spi.InfinispanDirectoryProvider;
import org.infinispan.query.indexmanager.InfinispanBackendQueueProcessor;
import org.infinispan.query.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InfinispanIndexManager
extends DirectoryBasedIndexManager {
    private static final Log log = (Log)LogFactory.getLog(InfinispanIndexManager.class, Log.class);
    private InfinispanBackendQueueProcessor remoteMaster;

    protected BackendQueueProcessor createBackend(String indexName, Properties cfg, WorkerBuildContext buildContext) {
        this.remoteMaster = new InfinispanBackendQueueProcessor();
        this.remoteMaster.initialize(cfg, buildContext, this);
        return this.remoteMaster;
    }

    protected DirectoryProvider createDirectoryProvider(String indexName, Properties cfg, WorkerBuildContext buildContext) {
        String directoryOption = cfg.getProperty("directory_provider", null);
        if (directoryOption != null && !"infinispan".equals(directoryOption)) {
            log.ignoreDirectoryProviderProperty(indexName, directoryOption);
        }
        InfinispanDirectoryProvider infinispanDP = new InfinispanDirectoryProvider();
        infinispanDP.initialize(indexName, cfg, (BuildContext)buildContext);
        return infinispanDP;
    }

    public boolean isMasterLocal() {
        return this.remoteMaster.isMasterLocal();
    }
}

