/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexmanager;

import java.util.List;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.infinispan.query.indexmanager.IndexingBackend;
import org.infinispan.query.logging.Log;
import org.infinispan.util.logging.LogFactory;

final class LocalIndexingBackend
implements IndexingBackend {
    private static final Log log = (Log)LogFactory.getLog(LocalIndexingBackend.class, Log.class);
    private final BackendQueueProcessor localBackend;

    public LocalIndexingBackend(BackendQueueProcessor localBackend) {
        this.localBackend = localBackend;
    }

    @Override
    public void applyWork(List<LuceneWork> workList, IndexingMonitor monitor, DirectoryBasedIndexManager indexManager) {
        log.applyingChangeListLocally(workList);
        this.localBackend.applyWork(workList, monitor);
    }

    @Override
    public void applyStreamWork(LuceneWork singleOperation, IndexingMonitor monitor, DirectoryBasedIndexManager indexManager) {
        this.localBackend.applyStreamWork(singleOperation, monitor);
    }

    @Override
    public boolean isMasterLocal() {
        return true;
    }

    @Override
    public void flushAndClose(IndexingBackend replacement) {
        this.localBackend.close();
        log.debug("Downgraded from Master role: Index lock released.");
    }

    public String toString() {
        return "LocalIndexingBackend";
    }
}

