/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.deployment;

import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jberet.repository.InMemoryRepository;
import org.jberet.repository.JdbcRepository;
import org.jberet.repository.JobRepository;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXMLParser;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.extension.batch.Attribute;
import org.wildfly.extension.batch.Element;
import org.wildfly.extension.batch._private.BatchLogger;

public class BatchDeploymentDescriptorParser
implements XMLStreamConstants,
JBossAllXMLParser<JobRepository> {
    public static final AttachmentKey<JobRepository> ATTACHMENT_KEY = AttachmentKey.create(JobRepository.class);
    public static final String NAMESPACE = "urn:jboss:batch:1.0";
    public static final QName ROOT_ELEMENT = new QName("urn:jboss:batch:1.0", "batch");

    public JobRepository parse(XMLExtendedStreamReader reader, DeploymentUnit deploymentUnit) throws XMLStreamException {
        String localName;
        Element element;
        if (reader.hasNext() && reader.nextTag() != 2 && (element = Element.forName(localName = reader.getLocalName())) == Element.JOB_REPOSITORY) {
            return this.parseJobRepository(reader, deploymentUnit);
        }
        BatchLogger.LOGGER.debugf("An empty batch element in the deployment descriptor was found for %s.", deploymentUnit.getName());
        return null;
    }

    private JobRepository parseJobRepository(XMLExtendedStreamReader reader, DeploymentUnit deploymentUnit) throws XMLStreamException {
        if (reader.hasNext() && reader.nextTag() != 2) {
            String localName = reader.getLocalName();
            Element element = Element.forName(localName);
            if (element == Element.IN_MEMORY) {
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                return new InMemoryRepository();
            }
            if (element == Element.JDBC) {
                String value = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.JNDI_NAME.getLocalName());
                Properties configProperties = new Properties();
                configProperties.setProperty("datasource-jndi", value);
                return JdbcRepository.create((Properties)configProperties);
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        BatchLogger.LOGGER.emptyJobRepositoryElement(deploymentUnit.getName());
        return null;
    }
}

