/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.host.controller.IgnoredNonAffectedServerGroupsUtil;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.as.version.ProductConfig;
import org.jboss.as.version.Version;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class HostInfo
implements TransformationTarget.IgnoredTransformationRegistry {
    private final String hostName;
    private final String releaseVersion;
    private final String releaseCodeName;
    private final int managementMajorVersion;
    private final int managementMinorVersion;
    private final int managementMicroVersion;
    private final String productName;
    private final String productVersion;
    private final Long remoteConnectionId;
    private final Map<String, IgnoredType> ignoredResources;
    private final boolean ignoreUnaffectedConfig;
    private final ConcurrentMap<String, IgnoredNonAffectedServerGroupsUtil.ServerConfigInfo> serverConfigInfos;

    public static ModelNode createLocalHostHostInfo(LocalHostControllerInfo hostInfo, ProductConfig productConfig, IgnoredDomainResourceRegistry ignoredResourceRegistry, Resource hostModelResource) {
        ModelNode ignoredModel;
        ModelNode info = new ModelNode();
        info.get("name").set(hostInfo.getLocalHostName());
        info.get("release-version").set(Version.AS_VERSION);
        info.get("release-codename").set(Version.AS_RELEASE_CODENAME);
        info.get("management-major-version").set(4);
        info.get("management-minor-version").set(0);
        info.get("management-micro-version").set(0);
        String productName = productConfig.getProductName();
        String productVersion = productConfig.getProductVersion();
        if (productName != null) {
            info.get("product-name").set(productName);
        }
        if (productVersion != null) {
            info.get("product-version").set(productVersion);
        }
        if ((ignoredModel = ignoredResourceRegistry.getIgnoredResourcesAsModel()).hasDefined("ignored-resource-type")) {
            info.get("ignored-resources").set(ignoredModel.require("ignored-resource-type"));
        }
        boolean ignoreUnaffectedServerGroups = hostInfo.isRemoteDomainControllerIgnoreUnaffectedConfiguration();
        IgnoredNonAffectedServerGroupsUtil.addCurrentServerGroupsToHostInfoModel(ignoreUnaffectedServerGroups, hostModelResource, info);
        return info;
    }

    public static HostInfo fromModelNode(ModelNode hostInfo) {
        return new HostInfo(hostInfo);
    }

    private HostInfo(ModelNode hostInfo) {
        this.hostName = hostInfo.require("name").asString();
        this.releaseVersion = hostInfo.require("release-version").asString();
        this.releaseCodeName = hostInfo.require("release-codename").asString();
        this.managementMajorVersion = hostInfo.require("management-major-version").asInt();
        this.managementMinorVersion = hostInfo.require("management-minor-version").asInt();
        this.managementMicroVersion = hostInfo.hasDefined("management-micro-version") ? hostInfo.require("management-micro-version").asInt() : 0;
        this.productName = hostInfo.hasDefined("product-name") ? hostInfo.require("product-name").asString() : null;
        this.productVersion = hostInfo.hasDefined("product-version") ? hostInfo.require("product-version").asString() : null;
        Long l = this.remoteConnectionId = hostInfo.hasDefined("domain-connection-id") ? Long.valueOf(hostInfo.get("domain-connection-id").asLong()) : null;
        if (hostInfo.hasDefined("ignored-resources")) {
            this.ignoredResources = new HashMap<String, IgnoredType>();
            for (Property prop : hostInfo.require("ignored-resources").asPropertyList()) {
                String type = prop.getName();
                ModelNode model = prop.getValue();
                IgnoredType ignoredType = model.get("wildcard").asBoolean(false) ? new IgnoredType() : new IgnoredType(model.get("names"));
                this.ignoredResources.put(type, ignoredType);
            }
        } else {
            this.ignoredResources = null;
        }
        this.ignoreUnaffectedConfig = hostInfo.hasDefined("ignore-unused-configuration") ? hostInfo.get("ignore-unused-configuration").asBoolean() : false;
        ConcurrentHashMap<String, IgnoredNonAffectedServerGroupsUtil.ServerConfigInfo> serverConfigInfos = new ConcurrentHashMap<String, IgnoredNonAffectedServerGroupsUtil.ServerConfigInfo>();
        if (this.ignoreUnaffectedConfig) {
            ModelNode initialServerGroups = hostInfo.get("initial-server-groups");
            for (Property prop : initialServerGroups.asPropertyList()) {
                List servers = prop.getValue().asList();
                for (ModelNode server : servers) {
                    String socketBindingGroupOverride = server.hasDefined("socket-binding-group") ? server.get("socket-binding-group").asString() : null;
                    IgnoredNonAffectedServerGroupsUtil.ServerConfigInfo serverConfigInfo = IgnoredNonAffectedServerGroupsUtil.createServerConfigInfo(prop.getName(), prop.getValue().get("group").asString(), socketBindingGroupOverride);
                    serverConfigInfos.put(serverConfigInfo.getName(), serverConfigInfo);
                }
            }
        }
        this.serverConfigInfos = serverConfigInfos;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getReleaseCodeName() {
        return this.releaseCodeName;
    }

    public int getManagementMajorVersion() {
        return this.managementMajorVersion;
    }

    public int getManagementMinorVersion() {
        return this.managementMinorVersion;
    }

    public int getManagementMicroVersion() {
        return this.managementMicroVersion;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public Long getRemoteConnectionId() {
        return this.remoteConnectionId;
    }

    public boolean isResourceTransformationIgnored(PathAddress address) {
        PathElement firstElement;
        IgnoredType ignoredType;
        return this.ignoredResources != null && address.size() > 0 && (ignoredType = this.ignoredResources.get((firstElement = address.getElement(0)).getKey())) != null && ignoredType.hasName(firstElement.getValue());
    }

    public boolean isIgnoreUnaffectedConfig() {
        return this.ignoreUnaffectedConfig;
    }

    public boolean isOperationTransformationIgnored(PathAddress address) {
        return false;
    }

    Collection<IgnoredNonAffectedServerGroupsUtil.ServerConfigInfo> getServerConfigInfos() {
        return this.serverConfigInfos.values();
    }

    void updateSlaveServerConfigInfo(IgnoredNonAffectedServerGroupsUtil.ServerConfigInfo serverInfo) {
        this.serverConfigInfos.put(serverInfo.getName(), serverInfo);
    }

    public String getPrettyProductName() {
        String result = this.productName != null ? ProductConfig.getPrettyVersionString((String)this.productName, (String)this.productVersion, (String)this.releaseVersion) : ProductConfig.getPrettyVersionString(null, (String)this.releaseVersion, (String)this.releaseCodeName);
        return result;
    }

    private static class IgnoredType {
        private final boolean wildcard;
        private final Set<String> names;

        private IgnoredType() {
            this.wildcard = true;
            this.names = null;
        }

        private IgnoredType(ModelNode names) {
            this.wildcard = false;
            if (names.isDefined()) {
                this.names = new HashSet<String>();
                for (ModelNode name : names.asList()) {
                    this.names.add(name.asString());
                }
            } else {
                this.names = null;
            }
        }

        private boolean hasName(String name) {
            return this.wildcard || this.names != null && this.names.contains(name);
        }
    }
}

