/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.HashSet;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.operations.DomainModelReferenceValidator;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.dmr.ModelNode;

public class DomainSocketBindingGroupRemoveHandler
extends AbstractRemoveStepHandler {
    public static final String OPERATION_NAME = "remove";
    public static final DomainSocketBindingGroupRemoveHandler INSTANCE = new DomainSocketBindingGroupRemoveHandler();
    private volatile ServerInventory serverInventory;

    protected DomainSocketBindingGroupRemoveHandler() {
    }

    public void initializeServerInventory(ServerInventory serverInventory) {
        this.serverInventory = serverInventory;
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.getRunningMode() == RunningMode.NORMAL && !context.isBooting();
    }

    protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                String socketBindingGroupName = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
                HashSet<String> serverGroups = new HashSet<String>();
                for (Resource.ResourceEntry entry : context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS).getChildren("server-group")) {
                    if (!entry.getModel().get("socket-binding-group").asString().equals(socketBindingGroupName)) continue;
                    serverGroups.add(entry.getName());
                }
                HashSet<String> runningServers = new HashSet<String>();
                for (Resource.ResourceEntry entry : ((Resource.ResourceEntry)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS).getChildren("host").iterator().next()).getChildren("server-config")) {
                    ModelNode configModel = entry.getModel();
                    if (configModel.hasDefined("socket-binding-group")) {
                        if (!configModel.get("socket-binding-group").asString().equals(socketBindingGroupName) || !DomainSocketBindingGroupRemoveHandler.this.isRunningServer(entry.getName())) continue;
                        runningServers.add(entry.getName());
                        continue;
                    }
                    if (!serverGroups.contains(configModel.get("group").asString()) || !DomainSocketBindingGroupRemoveHandler.this.isRunningServer(entry.getName())) continue;
                    runningServers.add(entry.getName());
                }
                if (!runningServers.isEmpty()) {
                    throw new OperationFailedException("Could not remove socket-binding-group since the following servers are running: " + runningServers);
                }
            }
        }, OperationContext.Stage.MODEL);
        DomainModelReferenceValidator.addValidationStep(context, operation);
        super.performRemove(context, operation, model);
    }

    private boolean isRunningServer(String serverName) {
        ServerStatus status = this.serverInventory.determineServerStatus(serverName);
        switch (status) {
            case STARTED: 
            case STARTING: 
            case STOPPING: {
                return true;
            }
        }
        return false;
    }
}

