/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.ArrayList;
import java.util.Collections;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.domain.controller.operations.GenericModelDescribeOperationHandler;
import org.jboss.as.domain.controller.resources.DomainResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ProfileCloneHandler
implements OperationStepHandler {
    public static final ProfileCloneHandler INSTANCE = new ProfileCloneHandler();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("clone", DomainResolver.getResolver("profile", false)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.READ_WHOLE_CONFIG).addParameter((AttributeDefinition)SimpleAttributeDefinitionBuilder.create((String)"to-profile", (ModelType)ModelType.STRING).build()).build();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String profileName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        final String newProfile = operation.require("to-profile").asString();
        String operationName = GenericModelDescribeOperationHandler.DEFINITION.getName();
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"profile", (String)profileName)});
        ModelNode describeOp = new ModelNode();
        describeOp.get("operation").set(operationName);
        describeOp.get("address").set(address.toModelNode());
        final ModelNode result = new ModelNode();
        OperationStepHandler handler = context.getRootResourceRegistration().getOperationHandler(address, operationName);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                PathAddress newPA = PathAddress.pathAddress((String)"profile", (String)newProfile);
                ArrayList operations = new ArrayList(result.get("result").asList());
                Collections.reverse(operations);
                for (ModelNode op : operations) {
                    PathAddress a = newPA.append(PathAddress.pathAddress((ModelNode)op.require("address")).subAddress(1));
                    op.get("address").set(a.toModelNode());
                    OperationStepHandler h = context.getRootResourceRegistration().getOperationHandler(a, op.get("operation").asString());
                    context.addStep(op, h, OperationContext.Stage.MODEL, true);
                }
            }
        }, OperationContext.Stage.MODEL, true);
        context.addStep(result, describeOp, handler, OperationContext.Stage.MODEL, true);
    }
}

