/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.service;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedAction;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.appclient.logging.AppClientLogger;
import org.jboss.ejb.client.ContextSelector;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.remoting.IoFutureHelper;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.Remoting;
import org.jboss.remoting3.remote.HttpUpgradeConnectionProviderFactory;
import org.jboss.remoting3.remote.RemoteConnectionProviderFactory;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;

public class LazyConnectionContextSelector
implements ContextSelector<EJBClientContext> {
    private final String hostUrl;
    private final CallbackHandler callbackHandler;
    private final ClassLoader classLoader;
    private Endpoint endpoint;
    private Connection connection;
    private volatile EJBClientContext clientContext;

    public LazyConnectionContextSelector(String hostUrl, CallbackHandler callbackHandler, ClassLoader classLoader) {
        this.hostUrl = hostUrl;
        this.callbackHandler = callbackHandler;
        this.classLoader = classLoader;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void createConnection() {
        try {
            this.endpoint = Remoting.createEndpoint((String)"endpoint", (OptionMap)OptionMap.EMPTY);
            this.endpoint.addConnectionProvider("remote", (ConnectionProviderFactory)new RemoteConnectionProviderFactory(), OptionMap.create((Option)Options.SSL_ENABLED, (Object)Boolean.FALSE));
            this.endpoint.addConnectionProvider("http-remoting", (ConnectionProviderFactory)new HttpUpgradeConnectionProviderFactory(), OptionMap.create((Option)Options.SSL_ENABLED, (Object)Boolean.FALSE));
            this.endpoint.addConnectionProvider("https-remoting", (ConnectionProviderFactory)new HttpUpgradeConnectionProviderFactory(), OptionMap.create((Option)Options.SSL_ENABLED, (Object)Boolean.TRUE));
            IoFuture futureConnection = this.endpoint.connect(new URI(this.hostUrl), OptionMap.create((Option)Options.SASL_POLICY_NOANONYMOUS, (Object)Boolean.FALSE, (Option)Options.SASL_POLICY_NOPLAINTEXT, (Object)Boolean.FALSE), this.callbackHandler);
            this.connection = (Connection)IoFutureHelper.get((IoFuture)futureConnection, (long)30L, (TimeUnit)TimeUnit.SECONDS);
            EJBClientContext ejbClientContext = EJBClientContext.create((ClassLoader)this.classLoader);
            ejbClientContext.registerConnection(this.connection);
            this.clientContext = ejbClientContext;
            if (this.clientContext != null) return;
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
                catch (URISyntaxException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                if (this.clientContext != null) throw throwable;
                IoUtils.safeClose((Closeable[])new Closeable[]{this.connection, this.endpoint});
                throw throwable;
            }
        }
        IoUtils.safeClose((Closeable[])new Closeable[]{this.connection, this.endpoint});
    }

    public EJBClientContext getCurrent() {
        return (EJBClientContext)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<EJBClientContext>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EJBClientContext run() {
                if (LazyConnectionContextSelector.this.clientContext == null) {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (LazyConnectionContextSelector.this.clientContext == null) {
                            LazyConnectionContextSelector.this.createConnection();
                        }
                    }
                }
                return LazyConnectionContextSelector.this.clientContext;
            }
        });
    }

    public synchronized void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (IOException e) {
            AppClientLogger.ROOT_LOGGER.exceptionClosingConnection(e);
        }
        try {
            if (this.endpoint != null) {
                this.endpoint.close();
            }
        }
        catch (IOException e) {
            AppClientLogger.ROOT_LOGGER.exceptionClosingConnection(e);
        }
    }
}

