/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.wildfly.security.auth.AuthenticationContext;
import org.wildfly.security.auth.ElytronXmlParser;
import org.wildfly.security.auth.InvalidAuthenticationConfigurationException;

class DefaultAuthenticationContextProvider {
    static final AuthenticationContext DEFAULT = AccessController.doPrivileged(new PrivilegedAction<AuthenticationContext>(){

        @Override
        public AuthenticationContext run() {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = DefaultAuthenticationContextProvider.class.getClassLoader();
            }
            try {
                return ElytronXmlParser.parseAuthenticationClientConfiguration().create();
            }
            catch (Throwable t) {
                throw new InvalidAuthenticationConfigurationException(t);
            }
        }
    });

    DefaultAuthenticationContextProvider() {
    }
}

