/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider;

import java.io.IOException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.CallbackUtil;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.spi.AuthenticatedRealmIdentity;
import org.wildfly.security.auth.spi.CredentialSupport;
import org.wildfly.security.auth.spi.RealmIdentity;
import org.wildfly.security.auth.spi.RealmUnavailableException;
import org.wildfly.security.auth.spi.SecurityRealm;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.password.interfaces.ClearPassword;

public class JAASSecurityRealm
implements SecurityRealm {
    private final String loginConfiguration;
    private CallbackHandler handler;

    public JAASSecurityRealm(String loginConfiguration) {
        this(loginConfiguration, null);
    }

    public JAASSecurityRealm(String loginConfiguration, CallbackHandler handler) {
        this.loginConfiguration = loginConfiguration;
        this.handler = handler;
    }

    @Override
    public RealmIdentity createRealmIdentity(Principal principal) throws RealmUnavailableException {
        if (!(principal instanceof NamePrincipal)) {
            throw ElytronMessages.log.invalidPrincipalType(NamePrincipal.class, principal == null ? null : principal.getClass());
        }
        return new JAASRealmIdentity(principal);
    }

    @Override
    public CredentialSupport getCredentialSupport(Class<?> credentialType) throws RealmUnavailableException {
        if (this.handler == null) {
            if (char[].class.isAssignableFrom(credentialType) || String.class.isAssignableFrom(credentialType) || ClearPassword.class.isAssignableFrom(credentialType)) {
                return CredentialSupport.VERIFIABLE_ONLY;
            }
            return CredentialSupport.UNSUPPORTED;
        }
        return CredentialSupport.POSSIBLY_VERIFIABLE;
    }

    private class CreateLoginContextAction
    implements PrivilegedExceptionAction<LoginContext> {
        private final String loginConfig;
        private final Subject subject;
        private final CallbackHandler handler;

        private CreateLoginContextAction(String loginConfig, Subject subject, CallbackHandler handler) {
            this.loginConfig = loginConfig;
            this.subject = subject;
            this.handler = handler;
        }

        @Override
        public LoginContext run() throws Exception {
            return new LoginContext(this.loginConfig, this.subject, this.handler);
        }
    }

    private class JAASAuthenticatedRealmIdentity
    implements AuthenticatedRealmIdentity {
        private final Principal principal;
        private final Subject subject;

        private JAASAuthenticatedRealmIdentity(Principal principal, Subject subject) {
            this.principal = principal;
            this.subject = subject;
        }

        @Override
        public void dispose() {
        }

        @Override
        public Principal getPrincipal() {
            return this.principal;
        }
    }

    private class DefaultCallbackHandler
    implements CallbackHandler {
        private final Principal principal;
        private final Object credential;

        private DefaultCallbackHandler(Principal principal, Object credential) {
            this.principal = principal;
            this.credential = credential;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            if (callbacks == null) {
                throw ElytronMessages.log.invalidNullCallbackArray();
            }
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nameCallback = (NameCallback)callback;
                    if (this.principal == null) continue;
                    nameCallback.setName(this.principal.getName());
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback passwordCallback = (PasswordCallback)callback;
                    if (this.credential instanceof char[]) {
                        passwordCallback.setPassword((char[])this.credential);
                        continue;
                    }
                    if (this.credential instanceof String) {
                        passwordCallback.setPassword(((String)this.credential).toCharArray());
                        continue;
                    }
                    if (this.credential instanceof ClearPassword) {
                        passwordCallback.setPassword(((ClearPassword)this.credential).getPassword());
                        continue;
                    }
                    throw ElytronMessages.log.failedToConvertCredentialToPassword(callback);
                }
                CallbackUtil.unsupported(callback);
            }
        }
    }

    private class JAASRealmIdentity
    implements RealmIdentity {
        private final Principal principal;
        private Subject subject;

        private JAASRealmIdentity(Principal principal) {
            this.principal = principal;
        }

        @Override
        public Principal getPrincipal() throws RealmUnavailableException {
            return this.principal;
        }

        @Override
        public CredentialSupport getCredentialSupport(Class<?> credentialType) throws RealmUnavailableException {
            if (JAASSecurityRealm.this.handler == null) {
                if (char[].class.isAssignableFrom(credentialType) || String.class.isAssignableFrom(credentialType) || ClearPassword.class.isAssignableFrom(credentialType)) {
                    return CredentialSupport.VERIFIABLE_ONLY;
                }
                return CredentialSupport.UNSUPPORTED;
            }
            return CredentialSupport.POSSIBLY_VERIFIABLE;
        }

        @Override
        public <C> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return null;
        }

        @Override
        public boolean verifyCredential(Object credential) throws RealmUnavailableException {
            boolean successfulLogin;
            CallbackHandler callbackHandler = this.createCallbackHandler(credential);
            Subject subject = new Subject();
            LoginContext context = this.createLoginContext(JAASSecurityRealm.this.loginConfiguration, subject, callbackHandler);
            try {
                context.login();
                successfulLogin = true;
                this.subject = subject;
            }
            catch (LoginException le) {
                ElytronMessages.log.debugJAASAuthenticationFailure(this.principal, le);
                successfulLogin = false;
            }
            return successfulLogin;
        }

        @Override
        public void dispose() {
        }

        @Override
        public AuthenticatedRealmIdentity getAuthenticatedRealmIdentity() throws RealmUnavailableException {
            return new JAASAuthenticatedRealmIdentity(this.principal, this.subject);
        }

        private LoginContext createLoginContext(String loginConfig, Subject subject, CallbackHandler handler) throws RealmUnavailableException {
            if (WildFlySecurityManager.isChecking()) {
                try {
                    return AccessController.doPrivileged(new CreateLoginContextAction(loginConfig, subject, handler));
                }
                catch (PrivilegedActionException pae) {
                    throw ElytronMessages.log.failedToCreateLoginContext(pae.getCause());
                }
            }
            try {
                return new LoginContext(loginConfig, subject, handler);
            }
            catch (LoginException le) {
                throw ElytronMessages.log.failedToCreateLoginContext(le);
            }
        }

        private CallbackHandler createCallbackHandler(Object credential) throws RealmUnavailableException {
            if (JAASSecurityRealm.this.handler == null) {
                return new DefaultCallbackHandler(this.principal, credential);
            }
            try {
                CallbackHandler callbackHandler = (CallbackHandler)JAASSecurityRealm.this.handler.getClass().newInstance();
                Method setSecurityInfo = JAASSecurityRealm.this.handler.getClass().getMethod("setSecurityInfo", Principal.class, Object.class);
                setSecurityInfo.invoke((Object)callbackHandler, this.principal, credential);
                return callbackHandler;
            }
            catch (Exception e) {
                throw ElytronMessages.log.failedToInstantiateCustomHandler(e);
            }
        }
    }
}

