/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider.ldap;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.wildfly.security.auth.provider.ldap.DirContextFactory;

public class SimpleDirContextFactoryBuilder {
    private boolean built = false;
    private String initialContextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    private String providerUrl = null;
    private String securityAuthentication = "simple";
    private String securityPrincipal = null;
    private String securityCredential = null;

    private SimpleDirContextFactoryBuilder() {
    }

    public static SimpleDirContextFactoryBuilder builder() {
        return new SimpleDirContextFactoryBuilder();
    }

    public SimpleDirContextFactoryBuilder setInitialContextFactory(String initialContextFactory) {
        this.assertNotBuilt();
        this.initialContextFactory = initialContextFactory;
        return this;
    }

    public SimpleDirContextFactoryBuilder setProviderUrl(String providerUrl) {
        this.assertNotBuilt();
        this.providerUrl = providerUrl;
        return this;
    }

    public SimpleDirContextFactoryBuilder setSecurityAuthentication(String securityAuthentication) {
        this.assertNotBuilt();
        this.securityAuthentication = securityAuthentication;
        return this;
    }

    public SimpleDirContextFactoryBuilder setSecurityPrincipal(String securityPrincipal) {
        this.assertNotBuilt();
        this.securityPrincipal = securityPrincipal;
        return this;
    }

    public SimpleDirContextFactoryBuilder setSecurityCredential(String securityCredential) {
        this.assertNotBuilt();
        this.securityCredential = securityCredential;
        return this;
    }

    public DirContextFactory build() {
        this.assertNotBuilt();
        if (this.providerUrl == null) {
            throw new IllegalStateException("No provider URL has been set.");
        }
        this.built = true;
        return new SimpleDirContextFactory();
    }

    private void assertNotBuilt() {
        if (this.built) {
            throw new IllegalStateException("This builder has already been built.");
        }
    }

    private class SimpleDirContextFactory
    implements DirContextFactory {
        private SimpleDirContextFactory() {
        }

        @Override
        public DirContext obtainDirContext(DirContextFactory.ReferralMode mode) throws NamingException {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", SimpleDirContextFactoryBuilder.this.initialContextFactory);
            env.put("java.naming.provider.url", SimpleDirContextFactoryBuilder.this.providerUrl);
            env.put("java.naming.security.authentication", SimpleDirContextFactoryBuilder.this.securityAuthentication);
            if (SimpleDirContextFactoryBuilder.this.securityPrincipal != null) {
                env.put("java.naming.security.principal", SimpleDirContextFactoryBuilder.this.securityPrincipal);
            }
            if (SimpleDirContextFactoryBuilder.this.securityCredential != null) {
                env.put("java.naming.security.credentials", SimpleDirContextFactoryBuilder.this.securityCredential);
            }
            env.put("java.naming.referral", mode == null ? DirContextFactory.ReferralMode.IGNORE.getValue() : mode.getValue());
            return new InitialDirContext(env);
        }

        @Override
        public void returnContext(DirContext context) {
            if (context instanceof InitialDirContext) {
                try {
                    ((InitialDirContext)context).close();
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }
    }
}

