/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.impl;

import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import org.wildfly.security.password.impl.AbstractPasswordImpl;
import org.wildfly.security.password.interfaces.BSDUnixDESCryptPassword;
import org.wildfly.security.password.spec.BSDUnixDESCryptPasswordSpec;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.EncryptablePasswordSpec;
import org.wildfly.security.password.spec.HashedPasswordAlgorithmSpec;

class BSDUnixDESCryptPasswordImpl
extends AbstractPasswordImpl
implements BSDUnixDESCryptPassword {
    private static final long serialVersionUID = 4537505177089490619L;
    private final int iterationCount;
    private final int salt;
    private final byte[] hash;
    private static boolean tablesInitialized = false;
    private static final byte[] IP = new byte[]{58, 50, 42, 34, 26, 18, 10, 2, 60, 52, 44, 36, 28, 20, 12, 4, 62, 54, 46, 38, 30, 22, 14, 6, 64, 56, 48, 40, 32, 24, 16, 8, 57, 49, 41, 33, 25, 17, 9, 1, 59, 51, 43, 35, 27, 19, 11, 3, 61, 53, 45, 37, 29, 21, 13, 5, 63, 55, 47, 39, 31, 23, 15, 7};
    private static final int[][] ipMaskLeft = new int[8][256];
    private static final int[][] ipMaskRight = new int[8][256];
    private static final int[][] fpMaskLeft = new int[8][256];
    private static final int[][] fpMaskRight = new int[8][256];
    private static final byte[] initPerm = new byte[64];
    private static final byte[] finalPerm = new byte[64];
    private static final byte[] keyShifts = new byte[]{1, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1};
    private static final byte[] keyPerm = new byte[]{57, 49, 41, 33, 25, 17, 9, 1, 58, 50, 42, 34, 26, 18, 10, 2, 59, 51, 43, 35, 27, 19, 11, 3, 60, 52, 44, 36, 63, 55, 47, 39, 31, 23, 15, 7, 62, 54, 46, 38, 30, 22, 14, 6, 61, 53, 45, 37, 29, 21, 13, 5, 28, 20, 12, 4};
    private static final byte[] invKeyPerm = new byte[64];
    private static final int[][] keyPermMaskLeft = new int[8][128];
    private static final int[][] keyPermMaskRight = new int[8][128];
    private static final byte[] compPerm = new byte[]{14, 17, 11, 24, 1, 5, 3, 28, 15, 6, 21, 10, 23, 19, 12, 4, 26, 8, 16, 7, 27, 20, 13, 2, 41, 52, 31, 37, 47, 55, 30, 40, 51, 45, 33, 48, 44, 49, 39, 56, 34, 53, 46, 42, 50, 36, 29, 32};
    private static final int[] invCompPerm = new int[56];
    private static final int[][] compPermMaskLeft = new int[8][128];
    private static final int[][] compPermMaskRight = new int[8][128];
    private static final byte[][] SBox = new byte[][]{{14, 4, 13, 1, 2, 15, 11, 8, 3, 10, 6, 12, 5, 9, 0, 7, 0, 15, 7, 4, 14, 2, 13, 1, 10, 6, 12, 11, 9, 5, 3, 8, 4, 1, 14, 8, 13, 6, 2, 11, 15, 12, 9, 7, 3, 10, 5, 0, 15, 12, 8, 2, 4, 9, 1, 7, 5, 11, 3, 14, 10, 0, 6, 13}, {15, 1, 8, 14, 6, 11, 3, 4, 9, 7, 2, 13, 12, 0, 5, 10, 3, 13, 4, 7, 15, 2, 8, 14, 12, 0, 1, 10, 6, 9, 11, 5, 0, 14, 7, 11, 10, 4, 13, 1, 5, 8, 12, 6, 9, 3, 2, 15, 13, 8, 10, 1, 3, 15, 4, 2, 11, 6, 7, 12, 0, 5, 14, 9}, {10, 0, 9, 14, 6, 3, 15, 5, 1, 13, 12, 7, 11, 4, 2, 8, 13, 7, 0, 9, 3, 4, 6, 10, 2, 8, 5, 14, 12, 11, 15, 1, 13, 6, 4, 9, 8, 15, 3, 0, 11, 1, 2, 12, 5, 10, 14, 7, 1, 10, 13, 0, 6, 9, 8, 7, 4, 15, 14, 3, 11, 5, 2, 12}, {7, 13, 14, 3, 0, 6, 9, 10, 1, 2, 8, 5, 11, 12, 4, 15, 13, 8, 11, 5, 6, 15, 0, 3, 4, 7, 2, 12, 1, 10, 14, 9, 10, 6, 9, 0, 12, 11, 7, 13, 15, 1, 3, 14, 5, 2, 8, 4, 3, 15, 0, 6, 10, 1, 13, 8, 9, 4, 5, 11, 12, 7, 2, 14}, {2, 12, 4, 1, 7, 10, 11, 6, 8, 5, 3, 15, 13, 0, 14, 9, 14, 11, 2, 12, 4, 7, 13, 1, 5, 0, 15, 10, 3, 9, 8, 6, 4, 2, 1, 11, 10, 13, 7, 8, 15, 9, 12, 5, 6, 3, 0, 14, 11, 8, 12, 7, 1, 14, 2, 13, 6, 15, 0, 9, 10, 4, 5, 3}, {12, 1, 10, 15, 9, 2, 6, 8, 0, 13, 3, 4, 14, 7, 5, 11, 10, 15, 4, 2, 7, 12, 9, 5, 6, 1, 13, 14, 0, 11, 3, 8, 9, 14, 15, 5, 2, 8, 12, 3, 7, 0, 4, 10, 1, 13, 11, 6, 4, 3, 2, 12, 9, 5, 15, 10, 11, 14, 1, 7, 6, 0, 8, 13}, {4, 11, 2, 14, 15, 0, 8, 13, 3, 12, 9, 7, 5, 10, 6, 1, 13, 0, 11, 7, 4, 9, 1, 10, 14, 3, 5, 12, 2, 15, 8, 6, 1, 4, 11, 13, 12, 3, 7, 14, 10, 15, 6, 8, 0, 5, 9, 2, 6, 11, 13, 8, 1, 4, 10, 7, 9, 5, 0, 15, 14, 2, 3, 12}, {13, 2, 8, 4, 6, 15, 11, 1, 10, 9, 3, 14, 5, 0, 12, 7, 1, 15, 13, 8, 10, 3, 7, 4, 12, 5, 6, 11, 0, 14, 9, 2, 7, 11, 4, 1, 9, 12, 14, 2, 0, 6, 10, 13, 15, 3, 5, 8, 2, 1, 14, 7, 4, 10, 8, 13, 15, 12, 9, 0, 3, 5, 6, 11}};
    private static final int[][] mSBox = new int[4][4096];
    private static final byte[][] invSBox = new byte[8][64];
    private static final byte[] PBox = new byte[]{16, 7, 20, 21, 29, 12, 28, 17, 1, 15, 23, 26, 5, 18, 31, 10, 2, 8, 24, 14, 32, 27, 3, 9, 19, 13, 30, 6, 22, 11, 4, 25};
    private static final byte[] invPBox = new byte[32];
    private static final int[][] PSBox = new int[4][256];
    private static final int[] bits32 = new int[]{Integer.MIN_VALUE, 0x40000000, 0x20000000, 0x10000000, 0x8000000, 0x4000000, 0x2000000, 0x1000000, 0x800000, 0x400000, 0x200000, 0x100000, 524288, 262144, 131072, 65536, 32768, 16384, 8192, 4096, 2048, 1024, 512, 256, 128, 64, 32, 16, 8, 4, 2, 1};

    BSDUnixDESCryptPasswordImpl(BSDUnixDESCryptPasswordSpec passwordSpec) throws InvalidKeySpecException {
        this.salt = passwordSpec.getSalt();
        this.iterationCount = passwordSpec.getIterationCount();
        byte[] hash = passwordSpec.getHash();
        if (hash == null || hash.length != 8) {
            throw new InvalidKeySpecException("BSD DES crypt password hash must be 64 bits");
        }
        this.hash = (byte[])hash.clone();
    }

    BSDUnixDESCryptPasswordImpl(ClearPasswordSpec passwordSpec) {
        this.salt = ThreadLocalRandom.current().nextInt() & 0xFFFFFF;
        this.iterationCount = 5001;
        this.hash = BSDUnixDESCryptPasswordImpl.generateHash(this.salt, this.iterationCount, passwordSpec.getEncodedPassword());
    }

    BSDUnixDESCryptPasswordImpl(EncryptablePasswordSpec encryptableSpec) throws InvalidParameterSpecException {
        this(encryptableSpec.getPassword(), (HashedPasswordAlgorithmSpec)encryptableSpec.getAlgorithmParameterSpec());
    }

    private BSDUnixDESCryptPasswordImpl(char[] password, HashedPasswordAlgorithmSpec spec) throws InvalidParameterSpecException {
        int saltInt;
        byte[] saltBytes = spec.getSalt();
        if (saltBytes != null) {
            if (saltBytes.length != 3) {
                throw new InvalidParameterSpecException("Salt must be three bytes (24 bits)");
            }
            saltInt = (saltBytes[0] & 0xFF) << 16 | (saltBytes[1] & 0xFF) << 8 | saltBytes[2] & 0xFF;
        } else {
            saltInt = ThreadLocalRandom.current().nextInt() & 0xFFFFFF;
        }
        this.salt = saltInt;
        this.iterationCount = spec.getIterationCount() == 0 ? 5001 : spec.getIterationCount();
        this.hash = BSDUnixDESCryptPasswordImpl.generateHash(this.salt, this.iterationCount, password);
    }

    BSDUnixDESCryptPasswordImpl(BSDUnixDESCryptPassword password) throws InvalidKeyException {
        this.salt = password.getSalt();
        this.iterationCount = password.getIterationCount();
        byte[] hash = password.getHash();
        if (hash == null || hash.length != 8) {
            throw new InvalidKeyException("BSD DES crypt password hash must be 64 bits");
        }
        this.hash = (byte[])hash.clone();
    }

    @Override
    <S extends KeySpec> S getKeySpec(Class<S> keySpecType) throws InvalidKeySpecException {
        if (keySpecType.isAssignableFrom(BSDUnixDESCryptPasswordSpec.class)) {
            return (S)((KeySpec)keySpecType.cast(new BSDUnixDESCryptPasswordSpec((byte[])this.hash.clone(), this.salt, this.iterationCount)));
        }
        throw new InvalidKeySpecException();
    }

    @Override
    boolean verify(char[] guess) throws InvalidKeyException {
        return Arrays.equals(this.hash, BSDUnixDESCryptPasswordImpl.generateHash(this.salt, this.iterationCount, guess));
    }

    @Override
    <T extends KeySpec> boolean convertibleTo(Class<T> keySpecType) {
        return keySpecType.isAssignableFrom(BSDUnixDESCryptPasswordSpec.class);
    }

    @Override
    public String getAlgorithm() {
        return "bsd-crypt-des";
    }

    @Override
    public int getIterationCount() {
        return this.iterationCount;
    }

    @Override
    public int getSalt() {
        return this.salt;
    }

    @Override
    public byte[] getHash() {
        return (byte[])this.hash.clone();
    }

    private static byte[] generateHash(int salt, int iterationCount, char[] password) {
        byte[] bytes1 = BSDUnixDESCryptPasswordImpl.getNormalizedPasswordBytes(password);
        return BSDUnixDESCryptPasswordImpl.crypt(bytes1, salt, iterationCount);
    }

    private static void setupTables() {
        int k;
        int j;
        int i;
        int bits28Offset = 4;
        int bits24Offset = 8;
        int bits8Offset = 24;
        for (i = 0; i < 8; ++i) {
            for (j = 0; j < 64; ++j) {
                int b = j & 0x20 | (j & 1) << 4 | j >>> 1 & 0xF;
                BSDUnixDESCryptPasswordImpl.invSBox[i][j] = SBox[i][b];
            }
        }
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 64; ++j) {
                for (k = 0; k < 64; ++k) {
                    BSDUnixDESCryptPasswordImpl.mSBox[i][j << 6 | k] = (invSBox[i << 1][j] << 4 | invSBox[(i << 1) + 1][k]) & 0xFF;
                }
            }
        }
        for (i = 0; i < 64; ++i) {
            BSDUnixDESCryptPasswordImpl.finalPerm[i] = (byte)(IP[i] - 1);
            BSDUnixDESCryptPasswordImpl.initPerm[BSDUnixDESCryptPasswordImpl.finalPerm[i]] = (byte)i;
            BSDUnixDESCryptPasswordImpl.invKeyPerm[i] = -1;
        }
        for (i = 0; i < 56; ++i) {
            BSDUnixDESCryptPasswordImpl.invKeyPerm[BSDUnixDESCryptPasswordImpl.keyPerm[i] - 1] = (byte)i;
            BSDUnixDESCryptPasswordImpl.invCompPerm[i] = 255;
        }
        for (i = 0; i < 48; ++i) {
            BSDUnixDESCryptPasswordImpl.invCompPerm[BSDUnixDESCryptPasswordImpl.compPerm[i] - 1] = i;
        }
        for (i = 0; i < 8; ++i) {
            int outBit;
            int inBit;
            for (j = 0; j < 256; ++j) {
                BSDUnixDESCryptPasswordImpl.ipMaskLeft[i][j] = 0;
                BSDUnixDESCryptPasswordImpl.ipMaskRight[i][j] = 0;
                BSDUnixDESCryptPasswordImpl.fpMaskLeft[i][j] = 0;
                BSDUnixDESCryptPasswordImpl.fpMaskRight[i][j] = 0;
                for (k = 0; k < 8; ++k) {
                    inBit = 8 * i + k;
                    if ((j & bits32[bits8Offset + k]) == 0) continue;
                    outBit = initPerm[inBit];
                    if (outBit < 32) {
                        int[] nArray = ipMaskLeft[i];
                        int n = j;
                        nArray[n] = nArray[n] | bits32[outBit];
                    } else {
                        int[] nArray = ipMaskRight[i];
                        int n = j;
                        nArray[n] = nArray[n] | bits32[outBit - 32];
                    }
                    outBit = finalPerm[inBit];
                    if (outBit < 32) {
                        int[] nArray = fpMaskLeft[i];
                        int n = j;
                        nArray[n] = nArray[n] | bits32[outBit];
                        continue;
                    }
                    int[] nArray = fpMaskRight[i];
                    int n = j;
                    nArray[n] = nArray[n] | bits32[outBit - 32];
                }
            }
            for (j = 0; j < 128; ++j) {
                BSDUnixDESCryptPasswordImpl.keyPermMaskLeft[i][j] = 0;
                BSDUnixDESCryptPasswordImpl.keyPermMaskRight[i][j] = 0;
                for (k = 0; k < 7; ++k) {
                    inBit = 8 * i + k;
                    if ((j & bits32[bits8Offset + k + 1]) == 0 || (outBit = invKeyPerm[inBit]) == 255) continue;
                    if (outBit < 28) {
                        int[] nArray = keyPermMaskLeft[i];
                        int n = j;
                        nArray[n] = nArray[n] | bits32[bits28Offset + outBit];
                        continue;
                    }
                    int[] nArray = keyPermMaskRight[i];
                    int n = j;
                    nArray[n] = nArray[n] | bits32[bits28Offset + (outBit - 28)];
                }
                BSDUnixDESCryptPasswordImpl.compPermMaskLeft[i][j] = 0;
                BSDUnixDESCryptPasswordImpl.compPermMaskRight[i][j] = 0;
                for (k = 0; k < 7; ++k) {
                    inBit = 7 * i + k;
                    if ((j & bits32[bits8Offset + k + 1]) == 0 || (outBit = invCompPerm[inBit]) == 255) continue;
                    if (outBit < 24) {
                        int[] nArray = compPermMaskLeft[i];
                        int n = j;
                        nArray[n] = nArray[n] | bits32[bits24Offset + outBit];
                        continue;
                    }
                    int[] nArray = compPermMaskRight[i];
                    int n = j;
                    nArray[n] = nArray[n] | bits32[bits24Offset + outBit - 24];
                }
            }
        }
        for (i = 0; i < 32; ++i) {
            BSDUnixDESCryptPasswordImpl.invPBox[BSDUnixDESCryptPasswordImpl.PBox[i] - 1] = (byte)i;
        }
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 256; ++j) {
                BSDUnixDESCryptPasswordImpl.PSBox[i][j] = 0;
                for (k = 0; k < 8; ++k) {
                    if ((j & bits32[bits8Offset + k]) == 0) continue;
                    int[] nArray = PSBox[i];
                    int n = j;
                    nArray[n] = nArray[n] | bits32[invPBox[8 * i + k]];
                }
            }
        }
        tablesInitialized = true;
    }

    static byte[] crypt(byte[] password, int salt, int iterationCount) {
        int[] currentSchedule;
        byte[] hash = new byte[8];
        if (iterationCount < 1 || iterationCount > 0xFFFFFF) {
            throw new IllegalArgumentException("Invalid number of rounds. Must be an integer between 1 and 16777215, inclusive");
        }
        if (!tablesInitialized) {
            BSDUnixDESCryptPasswordImpl.setupTables();
        }
        byte[] currentKey = BSDUnixDESCryptPasswordImpl.getKeyGroup(password, 0);
        int passwordLen = password.length;
        for (int nextStartIndex = 8; nextStartIndex < passwordLen; nextStartIndex += 8) {
            currentSchedule = BSDUnixDESCryptPasswordImpl.desSetKey(currentKey);
            hash = BSDUnixDESCryptPasswordImpl.desCipher(currentSchedule, BSDUnixDESCryptPasswordImpl.fourBytesToInt(currentKey, 0), BSDUnixDESCryptPasswordImpl.fourBytesToInt(currentKey, 4), 0, 1);
            byte[] nextGroup = BSDUnixDESCryptPasswordImpl.getKeyGroup(password, nextStartIndex);
            for (int i = 0; i < nextGroup.length; ++i) {
                currentKey[i] = (byte)(hash[i] ^ nextGroup[i]);
            }
        }
        currentSchedule = BSDUnixDESCryptPasswordImpl.desSetKey(currentKey);
        hash = BSDUnixDESCryptPasswordImpl.desCipher(currentSchedule, 0, 0, salt, iterationCount);
        return hash;
    }

    private static byte[] getKeyGroup(byte[] password, int startIndex) {
        byte[] keyGroup = new byte[8];
        for (int i = 0; i < keyGroup.length; ++i) {
            keyGroup[i] = 0;
        }
        int index = startIndex;
        for (int i = 0; i < keyGroup.length && index < password.length; ++i) {
            byte iChar = password[index++];
            keyGroup[i] = (byte)(iChar << 1);
        }
        return keyGroup;
    }

    private static int[] desSetKey(byte[] key) {
        int[] schedule = new int[32];
        int key0 = BSDUnixDESCryptPasswordImpl.fourBytesToInt(key, 0);
        int key1 = BSDUnixDESCryptPasswordImpl.fourBytesToInt(key, 4);
        int k0 = keyPermMaskLeft[0][key0 >>> 25] | keyPermMaskLeft[1][key0 >>> 17 & 0x7F] | keyPermMaskLeft[2][key0 >>> 9 & 0x7F] | keyPermMaskLeft[3][key0 >>> 1 & 0x7F] | keyPermMaskLeft[4][key1 >>> 25] | keyPermMaskLeft[5][key1 >>> 17 & 0x7F] | keyPermMaskLeft[6][key1 >>> 9 & 0x7F] | keyPermMaskLeft[7][key1 >>> 1 & 0x7F];
        int k1 = keyPermMaskRight[0][key0 >>> 25] | keyPermMaskRight[1][key0 >>> 17 & 0x7F] | keyPermMaskRight[2][key0 >>> 9 & 0x7F] | keyPermMaskRight[3][key0 >>> 1 & 0x7F] | keyPermMaskRight[4][key1 >>> 25] | keyPermMaskRight[5][key1 >>> 17 & 0x7F] | keyPermMaskRight[6][key1 >>> 9 & 0x7F] | keyPermMaskRight[7][key1 >>> 1 & 0x7F];
        int shifts = 0;
        int j = 0;
        for (int i = 0; i < 16; ++i) {
            int t0 = k0 << (shifts += keyShifts[i]) | k0 >>> 28 - shifts;
            int t1 = k1 << shifts | k1 >>> 28 - shifts;
            schedule[j++] = compPermMaskLeft[0][t0 >>> 21 & 0x7F] | compPermMaskLeft[1][t0 >>> 14 & 0x7F] | compPermMaskLeft[2][t0 >>> 7 & 0x7F] | compPermMaskLeft[3][t0 & 0x7F] | compPermMaskLeft[4][t1 >>> 21 & 0x7F] | compPermMaskLeft[5][t1 >>> 14 & 0x7F] | compPermMaskLeft[6][t1 >>> 7 & 0x7F] | compPermMaskLeft[7][t1 & 0x7F];
            schedule[j++] = compPermMaskRight[0][t0 >>> 21 & 0x7F] | compPermMaskRight[1][t0 >>> 14 & 0x7F] | compPermMaskRight[2][t0 >>> 7 & 0x7F] | compPermMaskRight[3][t0 & 0x7F] | compPermMaskRight[4][t1 >>> 21 & 0x7F] | compPermMaskRight[5][t1 >>> 14 & 0x7F] | compPermMaskRight[6][t1 >>> 7 & 0x7F] | compPermMaskRight[7][t1 & 0x7F];
        }
        return schedule;
    }

    private static byte[] desCipher(int[] schedule, int leftInput, int rightInput, int salt, int iterationCount) {
        int f = 0;
        byte[] hash = new byte[8];
        int rearrangedSalt = BSDUnixDESCryptPasswordImpl.setupSalt(salt);
        int l = ipMaskLeft[0][leftInput >>> 24] | ipMaskLeft[1][leftInput >>> 16 & 0xFF] | ipMaskLeft[2][leftInput >>> 8 & 0xFF] | ipMaskLeft[3][leftInput & 0xFF] | ipMaskLeft[4][rightInput >>> 24] | ipMaskLeft[5][rightInput >>> 16 & 0xFF] | ipMaskLeft[6][rightInput >>> 8 & 0xFF] | ipMaskLeft[7][rightInput & 0xFF];
        int r = ipMaskRight[0][leftInput >>> 24] | ipMaskRight[1][leftInput >>> 16 & 0xFF] | ipMaskRight[2][leftInput >>> 8 & 0xFF] | ipMaskRight[3][leftInput & 0xFF] | ipMaskRight[4][rightInput >>> 24] | ipMaskRight[5][rightInput >>> 16 & 0xFF] | ipMaskRight[6][rightInput >>> 8 & 0xFF] | ipMaskRight[7][rightInput & 0xFF];
        for (int i = 0; i < iterationCount; ++i) {
            int k = 0;
            for (int j = 0; j < 16; ++j) {
                int rLeft = (r & 1) << 23 | (r & 0xF8000000) >>> 9 | (r & 0x1F800000) >>> 11 | (r & 0x1F80000) >>> 13 | (r & 0x1F8000) >>> 15;
                int rRight = (r & 0x1F800) << 7 | (r & 0x1F80) << 5 | (r & 0x1F8) << 3 | (r & 0x1F) << 1 | (r & Integer.MIN_VALUE) >>> 31;
                f = (rLeft ^ rRight) & rearrangedSalt;
                rLeft ^= f ^ schedule[k++];
                rRight ^= f ^ schedule[k++];
                f = PSBox[0][mSBox[0][rLeft >>> 12]] | PSBox[1][mSBox[1][rLeft & 0xFFF]] | PSBox[2][mSBox[2][rRight >>> 12]] | PSBox[3][mSBox[3][rRight & 0xFFF]];
                l = r;
                r = f ^= l;
            }
            r = l;
            l = f;
        }
        int leftOutput = fpMaskLeft[0][l >>> 24] | fpMaskLeft[1][l >>> 16 & 0xFF] | fpMaskLeft[2][l >>> 8 & 0xFF] | fpMaskLeft[3][l & 0xFF] | fpMaskLeft[4][r >>> 24] | fpMaskLeft[5][r >>> 16 & 0xFF] | fpMaskLeft[6][r >>> 8 & 0xFF] | fpMaskLeft[7][r & 0xFF];
        int rightOutput = fpMaskRight[0][l >>> 24] | fpMaskRight[1][l >>> 16 & 0xFF] | fpMaskRight[2][l >>> 8 & 0xFF] | fpMaskRight[3][l & 0xFF] | fpMaskRight[4][r >>> 24] | fpMaskRight[5][r >>> 16 & 0xFF] | fpMaskRight[6][r >>> 8 & 0xFF] | fpMaskRight[7][r & 0xFF];
        BSDUnixDESCryptPasswordImpl.intToFourBytes(leftOutput, hash, 0);
        BSDUnixDESCryptPasswordImpl.intToFourBytes(rightOutput, hash, 4);
        return hash;
    }

    private static int setupSalt(int salt) {
        int resultBit = 0x800000;
        int saltBit = 1;
        int result = 0;
        for (int i = 0; i < 24; ++i) {
            if ((salt & saltBit) != 0) {
                result |= resultBit;
            }
            saltBit <<= 1;
            resultBit >>= 1;
        }
        return result;
    }

    private static int fourBytesToInt(byte[] b, int offset) {
        byte b4 = b[offset++];
        int value = (b4 & 0xFF) << 24;
        byte b3 = b[offset++];
        value |= (b3 & 0xFF) << 16;
        byte b2 = b[offset++];
        value |= (b2 & 0xFF) << 8;
        byte b1 = b[offset];
        return value |= b1 & 0xFF;
    }

    private static void intToFourBytes(int iValue, byte[] b, int offset) {
        b[offset++] = (byte)(iValue >>> 24 & 0xFF);
        b[offset++] = (byte)(iValue >>> 16 & 0xFF);
        b[offset++] = (byte)(iValue >>> 8 & 0xFF);
        b[offset] = (byte)(iValue & 0xFF);
    }
}

