/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.anonymous;

import java.nio.charset.StandardCharsets;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import org.wildfly.security.auth.callback.AnonymousAuthorizationCallback;
import org.wildfly.security.sasl.util.AbstractSaslServer;

public final class AnonymousSaslServer
extends AbstractSaslServer {
    private static final int INITIAL_STATE = 1;

    public AnonymousSaslServer(String protocol, String serverName, CallbackHandler callbackHandler) {
        super("ANONYMOUS", protocol, serverName, callbackHandler);
        this.setNegotiationState(1);
    }

    @Override
    public String getAuthorizationID() {
        return "anonymous";
    }

    @Override
    protected byte[] evaluateMessage(int state, byte[] message) throws SaslException {
        switch (state) {
            case 1: {
                int length = message.length;
                if (length == 0) {
                    return NO_BYTES;
                }
                if (length > 1020) {
                    throw new SaslException("Authentication name string is too long");
                }
                String name = new String(message, StandardCharsets.UTF_8);
                if (name.length() > 255) {
                    throw new SaslException("Authentication name string is too long");
                }
                AnonymousAuthorizationCallback callback = new AnonymousAuthorizationCallback(name);
                this.handleCallbacks(callback);
                if (!callback.isAuthorized()) {
                    throw new SaslException("Authorization for anonymous access is denied");
                }
                this.negotiationComplete();
                return null;
            }
        }
        throw new SaslException("Invalid state");
    }
}

