/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.launcher;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.wildfly.core.launcher.Arguments;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.VersionComparator;
import org.wildfly.core.launcher.logger.LauncherMessages;

abstract class AbstractCommandBuilder<T extends AbstractCommandBuilder<T>>
implements CommandBuilder {
    private static final String MODULES_JAR_NAME = "jboss-modules.jar";
    private static final String JAVA_EXE = "java" + AbstractCommandBuilder.getExeSuffix();
    static final String HOME_DIR = "jboss.home.dir";
    static final String SECURITY_MANAGER_ARG = "-secmgr";
    static final String SECURITY_MANAGER_PROP = "java.security.manager";
    static final String[] DEFAULT_VM_ARGUMENTS;
    private final Path wildflyHome;
    private boolean useSecMgr;
    private final List<String> modulesDirs;
    private Path logDir;
    private Path configDir;
    private final Arguments serverArgs;
    private boolean addDefaultModuleDir;

    protected AbstractCommandBuilder(Path wildflyHome) {
        this.wildflyHome = wildflyHome;
        this.useSecMgr = false;
        this.modulesDirs = new ArrayList<String>();
        this.serverArgs = new Arguments();
        this.addDefaultModuleDir = true;
    }

    public T setUseSecurityManager(boolean useSecMgr) {
        this.useSecMgr = useSecMgr;
        return this.getThis();
    }

    public boolean useSecurityManager() {
        return this.useSecMgr;
    }

    public T addModuleDir(String moduleDir) {
        if (moduleDir == null) {
            throw LauncherMessages.MESSAGES.nullParam("moduleDir");
        }
        Path path = Paths.get(moduleDir, new String[0]).normalize();
        this.modulesDirs.add(path.toString());
        return this.getThis();
    }

    public T addModuleDirs(String ... moduleDirs) {
        for (String path : moduleDirs) {
            this.addModuleDir(path);
        }
        return this.getThis();
    }

    public T addModuleDirs(Iterable<String> moduleDirs) {
        for (String path : moduleDirs) {
            this.addModuleDir(path);
        }
        return this.getThis();
    }

    public T setModuleDirs(Iterable<String> moduleDirs) {
        this.modulesDirs.clear();
        for (String path : moduleDirs) {
            this.addModuleDir(path);
        }
        this.addDefaultModuleDir = false;
        return this.getThis();
    }

    public T setModuleDirs(String ... moduleDirs) {
        this.modulesDirs.clear();
        for (String path : moduleDirs) {
            this.addModuleDir(path);
        }
        this.addDefaultModuleDir = false;
        return this.getThis();
    }

    public String getModulePaths() {
        StringBuilder result = new StringBuilder();
        if (this.addDefaultModuleDir) {
            result.append(this.normalizePath("modules").toString());
        }
        if (!this.modulesDirs.isEmpty()) {
            if (this.addDefaultModuleDir) {
                result.append(File.pathSeparator);
            }
            Iterator<String> iterator = this.modulesDirs.iterator();
            while (iterator.hasNext()) {
                result.append(iterator.next());
                if (!iterator.hasNext()) continue;
                result.append(File.pathSeparator);
            }
        }
        return result.toString();
    }

    public Path getLogDirectory() {
        if (this.logDir == null) {
            return this.normalizePath(this.getBaseDirectory(), "log");
        }
        return this.logDir;
    }

    public T setLogDirectory(String path) {
        if (path == null) {
            this.logDir = null;
            return this.getThis();
        }
        return this.setLogDirectory(Paths.get(path, new String[0]));
    }

    public T setLogDirectory(Path path) {
        if (path == null) {
            this.logDir = null;
        } else {
            if (Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
                throw LauncherMessages.MESSAGES.invalidDirectory(path);
            }
            this.logDir = path.toAbsolutePath().normalize();
        }
        return this.getThis();
    }

    public Path getConfigurationDirectory() {
        if (this.configDir == null) {
            return this.normalizePath(this.getBaseDirectory(), "configuration");
        }
        return this.configDir;
    }

    public T setConfigurationDirectory(String path) {
        this.configDir = AbstractCommandBuilder.validateAndNormalizeDir(path, true);
        return this.getThis();
    }

    public T setConfigurationDirectory(Path path) {
        this.configDir = AbstractCommandBuilder.validateAndNormalizeDir(path, true);
        return this.getThis();
    }

    public T addServerArgument(String arg) {
        if (arg != null) {
            if (SECURITY_MANAGER_ARG.equals(arg)) {
                this.setUseSecurityManager(true);
            } else {
                this.serverArgs.add(arg);
            }
        }
        return this.getThis();
    }

    public T addServerArguments(String ... args) {
        if (args != null) {
            for (String arg : args) {
                this.addServerArgument(arg);
            }
        }
        return this.getThis();
    }

    public T addServerArguments(Iterable<String> args) {
        if (args != null) {
            for (String arg : args) {
                this.addServerArgument(arg);
            }
        }
        return this.getThis();
    }

    public T setAdminOnly() {
        return this.addServerArgument("--admin-only");
    }

    public T setBindAddressHint(String address) {
        this.setSingleServerArg("-b", address);
        return this.getThis();
    }

    public T setBindAddressHint(String interfaceName, String address) {
        if (interfaceName == null) {
            throw LauncherMessages.MESSAGES.nullParam("interfaceName");
        }
        this.setSingleServerArg("-b" + interfaceName, address);
        return this.getThis();
    }

    public T setMulticastAddressHint(String address) {
        this.setSingleServerArg("-u", address);
        return this.getThis();
    }

    public T addPropertiesFile(String file) {
        if (file != null) {
            this.addPropertiesFile(Paths.get(file, new String[0]));
        }
        return this.getThis();
    }

    public T addPropertiesFile(Path file) {
        if (file != null) {
            if (Files.notExists(file, new LinkOption[0])) {
                throw LauncherMessages.MESSAGES.pathDoesNotExist(file);
            }
            if (!Files.isRegularFile(file, new LinkOption[0])) {
                throw LauncherMessages.MESSAGES.pathNotAFile(file);
            }
            this.addServerArg("-P", file.toAbsolutePath().normalize().toString());
        }
        return this.getThis();
    }

    public T setPropertiesFile(String file) {
        Path path = file == null ? null : Paths.get(file, new String[0]);
        return this.setPropertiesFile(path);
    }

    public T setPropertiesFile(Path file) {
        this.serverArgs.remove("-P");
        return this.addPropertiesFile(file);
    }

    public Path getWildFlyHome() {
        return this.wildflyHome;
    }

    public abstract Path getJavaHome();

    protected String getJavaCommand() {
        return this.getJavaCommand(this.getJavaHome());
    }

    protected String getJavaCommand(Path javaHome) {
        String exe = javaHome.resolve("bin").resolve("java").toString();
        if (exe.contains(" ")) {
            return "\"" + exe + "\"";
        }
        return exe;
    }

    protected String getLoggingPropertiesArgument(String fileName) {
        return "-Dlogging.configuration=file:" + this.normalizePath(this.getConfigurationDirectory(), fileName);
    }

    protected String getBootLogArgument(String fileName) {
        return "-Dorg.jboss.boot.log.file=" + this.normalizePath(this.getLogDirectory(), fileName);
    }

    public String getModulesJarName() {
        return this.normalizePath(MODULES_JAR_NAME).toString();
    }

    protected Path normalizePath(String path) {
        return this.normalizePath(this.wildflyHome, path);
    }

    protected Path normalizePath(Path parent, String path) {
        return parent.resolve(path).toAbsolutePath().normalize();
    }

    public abstract Path getBaseDirectory();

    public List<String> getServerArguments() {
        return this.serverArgs.asList();
    }

    protected abstract T getThis();

    protected void setSingleServerArg(String key, String value) {
        this.serverArgs.set(key, value);
    }

    protected void addServerArg(String key, String value) {
        this.serverArgs.add(key, value);
    }

    protected String getServerArg(String key) {
        return this.serverArgs.get(key);
    }

    protected static Path resolveJavaHome(Path javaHome) {
        if (javaHome == null) {
            return AbstractCommandBuilder.validateJavaHome(System.getProperty("java.home"));
        }
        return AbstractCommandBuilder.validateJavaHome(javaHome);
    }

    protected static Path validateWildFlyDir(String wildflyHome) {
        Path result = AbstractCommandBuilder.validateAndNormalizeDir(wildflyHome, false);
        if (Files.notExists(result.resolve(MODULES_JAR_NAME), new LinkOption[0])) {
            throw LauncherMessages.MESSAGES.invalidDirectory(MODULES_JAR_NAME, result);
        }
        return result;
    }

    protected static Path validateWildFlyDir(Path wildflyHome) {
        Path result = AbstractCommandBuilder.validateAndNormalizeDir(wildflyHome, false);
        if (Files.notExists(result.resolve(MODULES_JAR_NAME), new LinkOption[0])) {
            throw LauncherMessages.MESSAGES.invalidDirectory(MODULES_JAR_NAME, wildflyHome);
        }
        return result;
    }

    protected static Path validateJavaHome(String javaHome) {
        if (javaHome == null) {
            throw LauncherMessages.MESSAGES.pathDoesNotExist(null);
        }
        return AbstractCommandBuilder.validateJavaHome(Paths.get(javaHome, new String[0]));
    }

    protected static Path validateJavaHome(Path javaHome) {
        Path result = AbstractCommandBuilder.validateAndNormalizeDir(javaHome, false);
        Path exe = result.resolve("bin").resolve(JAVA_EXE);
        if (Files.notExists(exe, new LinkOption[0])) {
            int count = exe.getNameCount();
            throw LauncherMessages.MESSAGES.invalidDirectory(exe.subpath(count - 2, count).toString(), javaHome);
        }
        return result;
    }

    protected static Path validateAndNormalizeDir(String path, boolean allowNull) {
        if (path == null) {
            if (allowNull) {
                return null;
            }
            throw LauncherMessages.MESSAGES.pathDoesNotExist(null);
        }
        return AbstractCommandBuilder.validateAndNormalizeDir(Paths.get(path, new String[0]), allowNull);
    }

    protected static Path validateAndNormalizeDir(Path path, boolean allowNull) {
        if (allowNull && path == null) {
            return null;
        }
        if (path == null || Files.notExists(path, new LinkOption[0])) {
            throw LauncherMessages.MESSAGES.pathDoesNotExist(path);
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw LauncherMessages.MESSAGES.invalidDirectory(path);
        }
        return path.toAbsolutePath().normalize();
    }

    protected static void addSystemPropertyArg(List<String> cmd, String key, Object value) {
        if (value != null) {
            cmd.add("-D" + key + "=" + value);
        }
    }

    private static String getExeSuffix() {
        String os = System.getProperty("os.name");
        if (os != null && os.toLowerCase(Locale.ROOT).contains("win")) {
            return ".exe";
        }
        return "";
    }

    static {
        String jvmVersion = System.getProperty("java.specification.version");
        ArrayList<String> javaOpts = new ArrayList<String>();
        javaOpts.add("-Xms64m");
        javaOpts.add("-Xmx512m");
        javaOpts.add("-Djava.net.preferIPv4Stack=true");
        javaOpts.add("-Djava.awt.headless=true");
        javaOpts.add("-Djboss.modules.system.pkgs=org.jboss.byteman");
        if (VersionComparator.compareVersion(jvmVersion, "1.8") < 0) {
            javaOpts.add("-XX:MaxPermSize=256m");
        }
        DEFAULT_VM_ARGUMENTS = javaOpts.toArray(new String[javaOpts.size()]);
    }
}

