/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.attributes;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeCopier;
import org.infinispan.commons.configuration.attributes.AttributeInitializer;
import org.infinispan.commons.configuration.attributes.AttributeValidator;

public final class AttributeDefinition<T> {
    private final String name;
    private final T defaultValue;
    private boolean immutable;
    private final AttributeCopier copier;
    private final AttributeInitializer<? extends T> initializer;
    private final AttributeValidator<? super T> validator;
    private final Class<?> type;

    AttributeDefinition(String name, T initialValue, Class<T> type, boolean immutable, AttributeCopier copier, AttributeValidator<? super T> validator, AttributeInitializer<? extends T> initializer) {
        this.name = name;
        this.defaultValue = initialValue;
        this.immutable = immutable;
        this.copier = copier;
        this.initializer = initializer;
        this.validator = validator;
        this.type = type;
    }

    public String name() {
        return this.name;
    }

    public Class<T> getType() {
        return this.type;
    }

    public T getDefaultValue() {
        return this.initializer != null ? this.initializer().initialize() : this.defaultValue;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public AttributeCopier copier() {
        return this.copier;
    }

    public AttributeInitializer<? extends T> initializer() {
        return this.initializer;
    }

    AttributeValidator<? super T> validator() {
        return this.validator;
    }

    public Attribute<T> toAttribute() {
        return new Attribute(this);
    }

    public void validate(T value) {
        if (this.validator != null) {
            this.validator.validate(value);
        }
    }

    public static <T> Builder<T> builder(String name, T defaultValue) {
        if (defaultValue != null) {
            return new Builder(name, defaultValue, defaultValue.getClass());
        }
        throw new CacheConfigurationException("Must specify type when passing null for AttributeDefinition " + name);
    }

    public static <T> Builder<T> builder(String name, T defaultValue, Class<T> klass) {
        return new Builder(name, defaultValue, klass);
    }

    public static final class Builder<T> {
        private final String name;
        private final T defaultValue;
        private final Class<?> type;
        private boolean immutable = false;
        private AttributeCopier copier = null;
        private AttributeInitializer<? extends T> initializer;
        private AttributeValidator<? super T> validator;

        private Builder(String name, T defaultValue, Class<T> type) {
            this.name = name;
            this.defaultValue = defaultValue;
            this.type = type;
        }

        public Builder<T> immutable() {
            this.immutable = true;
            return this;
        }

        public Builder<T> copier(AttributeCopier copier) {
            this.copier = copier;
            return this;
        }

        public Builder<T> initializer(AttributeInitializer<? extends T> initializer) {
            this.initializer = initializer;
            return this;
        }

        public Builder<T> validator(AttributeValidator<? super T> validator) {
            this.validator = validator;
            return this;
        }

        public AttributeDefinition<T> build() {
            return new AttributeDefinition<T>(this.name, this.defaultValue, this.type, this.immutable, this.copier, this.validator, this.initializer);
        }
    }
}

