/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SecureRandomSessionIdGenerator;
import io.undertow.server.session.SessionIdGenerator;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ThreadSetupAction;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.session.SessionContext;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.undertow.IdentifierFactoryAdapter;
import org.wildfly.clustering.web.undertow.session.DistributableSessionManager;
import org.wildfly.clustering.web.undertow.session.LocalSessionContext;
import org.wildfly.clustering.web.undertow.session.LocalSessionContextFactory;
import org.wildfly.clustering.web.undertow.session.UndertowSessionContext;

public class DistributableSessionManagerFactory
implements io.undertow.servlet.api.SessionManagerFactory {
    private final SessionManagerFactory<Batch> factory;

    public DistributableSessionManagerFactory(SessionManagerFactory<Batch> factory) {
        this.factory = factory;
    }

    public SessionManager createSessionManager(Deployment deployment) {
        UndertowSessionContext context = new UndertowSessionContext(deployment);
        IdentifierFactoryAdapter factory = new IdentifierFactoryAdapter((SessionIdGenerator)new SecureRandomSessionIdGenerator());
        final org.wildfly.clustering.web.session.SessionManager manager = this.factory.createSessionManager((SessionContext)context, (IdentifierFactory)factory, (LocalContextFactory)new LocalSessionContextFactory());
        DeploymentInfo info = deployment.getDeploymentInfo();
        ThreadSetupAction action = new ThreadSetupAction(){

            public ThreadSetupAction.Handle setup(HttpServerExchange exchange) {
                return new ThreadSetupAction.Handle(){

                    public void tearDown() {
                        Batch batch = manager.getBatcher().suspendBatch();
                        if (batch != null) {
                            UndertowLogger.REQUEST_LOGGER.tracef("Suspending residual active batch: %s", (Object)batch);
                        }
                    }
                };
            }
        };
        info.addThreadSetupAction(action);
        return new DistributableSessionManager(info.getDeploymentName(), (org.wildfly.clustering.web.session.SessionManager<LocalSessionContext, Batch>)manager);
    }
}

