/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Exportable;
import org.hibernate.boot.model.relational.InitCommand;
import org.hibernate.boot.model.relational.Schema;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.tool.schema.spi.SchemaCreator;
import org.hibernate.tool.schema.spi.SchemaManagementException;
import org.hibernate.tool.schema.spi.Target;

public class SchemaCreatorImpl
implements SchemaCreator {
    @Override
    public void doCreation(Metadata metadata, boolean createSchemas, List<Target> targets) throws SchemaManagementException {
        this.doCreation(metadata, createSchemas, targets.toArray(new Target[targets.size()]));
    }

    @Override
    public void doCreation(Metadata metadata, boolean createSchemas, Dialect dialect, List<Target> targets) throws SchemaManagementException {
        this.doCreation(metadata, createSchemas, dialect, targets.toArray(new Target[targets.size()]));
    }

    public List<String> generateCreationCommands(Metadata metadata, boolean createSchemas) {
        final ArrayList<String> commands = new ArrayList<String>();
        this.doCreation(metadata, createSchemas, new Target(){

            @Override
            public boolean acceptsImportScriptActions() {
                return true;
            }

            @Override
            public void prepare() {
            }

            @Override
            public void accept(String action) {
                commands.add(action);
            }

            @Override
            public void release() {
            }
        });
        return commands;
    }

    public List<String> generateCreationCommands(Metadata metadata, boolean createSchemas, Dialect dialect) {
        final ArrayList<String> commands = new ArrayList<String>();
        this.doCreation(metadata, createSchemas, dialect, new Target(){

            @Override
            public boolean acceptsImportScriptActions() {
                return true;
            }

            @Override
            public void prepare() {
            }

            @Override
            public void accept(String action) {
                commands.add(action);
            }

            @Override
            public void release() {
            }
        });
        return commands;
    }

    @Override
    public void doCreation(Metadata metadata, boolean createSchemas, Target ... targets) throws SchemaManagementException {
        this.doCreation(metadata, createSchemas, metadata.getDatabase().getJdbcEnvironment().getDialect(), targets);
    }

    @Override
    public void doCreation(Metadata metadata, boolean createSchemas, Dialect dialect, Target ... targets) throws SchemaManagementException {
        Database database = metadata.getDatabase();
        JdbcEnvironment jdbcEnvironment = database.getJdbcEnvironment();
        for (Target target : targets) {
            target.prepare();
        }
        HashSet<String> exportIdentifiers = new HashSet<String>(50);
        for (Schema schema : database.getSchemas()) {
            if (!createSchemas || schema.getName().getSchema() == null) continue;
            SchemaCreatorImpl.applySqlStrings(targets, dialect.getCreateSchemaCommand(schema.getName().getSchema().render(dialect)));
        }
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : database.getAuxiliaryDatabaseObjects()) {
            if (!auxiliaryDatabaseObject.beforeTablesOnCreation() || !auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            SchemaCreatorImpl.applySqlStrings(targets, dialect.getAuxiliaryDatabaseObjectExporter().getSqlCreateStrings(auxiliaryDatabaseObject, metadata));
        }
        for (Schema schema : database.getSchemas()) {
            for (Sequence sequence : schema.getSequences()) {
                SchemaCreatorImpl.checkExportIdentifier(sequence, exportIdentifiers);
                SchemaCreatorImpl.applySqlStrings(targets, dialect.getCreateSequenceStrings(jdbcEnvironment.getQualifiedObjectNameFormatter().format(sequence.getName(), dialect), sequence.getInitialValue(), sequence.getIncrementSize()));
            }
            for (Table table : schema.getTables()) {
                if (!table.isPhysicalTable()) continue;
                SchemaCreatorImpl.checkExportIdentifier(table, exportIdentifiers);
                SchemaCreatorImpl.applySqlStrings(targets, dialect.getTableExporter().getSqlCreateStrings(table, metadata));
            }
            for (Table table : schema.getTables()) {
                Iterator<Index> indexItr = table.getIndexIterator();
                while (indexItr.hasNext()) {
                    Index index = indexItr.next();
                    SchemaCreatorImpl.checkExportIdentifier(index, exportIdentifiers);
                    SchemaCreatorImpl.applySqlStrings(targets, dialect.getIndexExporter().getSqlCreateStrings(index, metadata));
                }
                Iterator<UniqueKey> ukItr = table.getUniqueKeyIterator();
                while (ukItr.hasNext()) {
                    UniqueKey uniqueKey = ukItr.next();
                    SchemaCreatorImpl.checkExportIdentifier(uniqueKey, exportIdentifiers);
                    SchemaCreatorImpl.applySqlStrings(targets, dialect.getUniqueKeyExporter().getSqlCreateStrings(uniqueKey, metadata));
                }
                Iterator fkItr = table.getForeignKeyIterator();
                while (fkItr.hasNext()) {
                    ForeignKey foreignKey = (ForeignKey)fkItr.next();
                    SchemaCreatorImpl.applySqlStrings(targets, dialect.getForeignKeyExporter().getSqlCreateStrings(foreignKey, metadata));
                }
            }
        }
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : database.getAuxiliaryDatabaseObjects()) {
            if (!auxiliaryDatabaseObject.appliesToDialect(dialect) || auxiliaryDatabaseObject.beforeTablesOnCreation()) continue;
            SchemaCreatorImpl.checkExportIdentifier(auxiliaryDatabaseObject, exportIdentifiers);
            SchemaCreatorImpl.applySqlStrings(targets, dialect.getAuxiliaryDatabaseObjectExporter().getSqlCreateStrings(auxiliaryDatabaseObject, metadata));
        }
        for (InitCommand initCommand : database.getInitCommands()) {
            SchemaCreatorImpl.applySqlStrings(targets, initCommand.getInitCommands());
        }
        for (Iterator<Object> iterator : targets) {
            iterator.release();
        }
    }

    private static void checkExportIdentifier(Exportable exportable, Set<String> exportIdentifiers) {
        String exportIdentifier = exportable.getExportIdentifier();
        if (exportIdentifiers.contains(exportIdentifier)) {
            throw new SchemaManagementException("SQL strings added more than once for: " + exportIdentifier);
        }
        exportIdentifiers.add(exportIdentifier);
    }

    private static void applySqlStrings(Target[] targets, String ... sqlStrings) {
        if (sqlStrings == null) {
            return;
        }
        for (Target target : targets) {
            for (String sqlString : sqlStrings) {
                target.accept(sqlString);
            }
        }
    }
}

