/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.TrustKeyConfigurationException;
import org.picketlink.common.exceptions.TrustKeyProcessingException;
import org.picketlink.common.util.StringUtil;
import org.picketlink.config.federation.AuthPropertyType;
import org.picketlink.config.federation.KeyValueType;
import org.picketlink.identity.federation.core.impl.SecurityActions;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.util.EncryptionKeyUtil;
import org.picketlink.identity.federation.core.util.KeyStoreUtil;

public class KeyStoreKeyManager
implements TrustKeyManager {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private final Map<String, SecretKey> keys = new HashMap<String, SecretKey>();
    private final Map<String, Object> options = new HashMap<String, Object>();
    private final HashMap<String, String> domainAliasMap = new HashMap();
    private final HashMap<String, String> authPropsMap = new HashMap();
    private KeyStore ks = null;
    private String keyStoreURL;
    private char[] signingKeyPass;
    private String signingAlias;
    private String encryptionAlias;
    private char[] encryptionKeyPass;
    private String keyStorePass;
    public static final String KEYSTORE_URL = "KeyStoreURL";
    public static final String KEYSTORE_PASS = "KeyStorePass";
    public static final String SIGNING_KEY_PASS = "SigningKeyPass";
    public static final String SIGNING_KEY_ALIAS = "SigningKeyAlias";
    public static final String ENCRYPTION_KEY_PASS = "EncryptionKeyPass";
    public static final String ENCRYPTION_KEY_ALIAS = "EncryptionKeyAlias";

    @Override
    public PrivateKey getSigningKey() throws TrustKeyConfigurationException, TrustKeyProcessingException {
        if (this.signingKeyPass == null || this.signingKeyPass.length == 0) {
            throw logger.keyStoreNullSigningKeyPass();
        }
        try {
            this.initKeyStore();
            return (PrivateKey)this.ks.getKey(this.signingAlias, this.signingKeyPass);
        }
        catch (KeyStoreException e) {
            throw logger.keyStoreConfigurationError((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw logger.keyStoreProcessingError((Throwable)e);
        }
        catch (UnrecoverableKeyException e) {
            throw logger.keyStoreProcessingError((Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw logger.keyStoreProcessingError((Throwable)e);
        }
        catch (IOException e) {
            throw logger.keyStoreProcessingError((Throwable)e);
        }
    }

    @Override
    public KeyPair getSigningKeyPair() throws TrustKeyConfigurationException, TrustKeyProcessingException {
        if (this.signingKeyPass == null || this.signingKeyPass.length == 0) {
            throw logger.keyStoreNullSigningKeyPass();
        }
        try {
            this.initKeyStore();
            PrivateKey privateKey = this.getSigningKey();
            PublicKey publicKey = KeyStoreUtil.getPublicKey(this.ks, this.signingAlias, this.signingKeyPass);
            return new KeyPair(publicKey, privateKey);
        }
        catch (KeyStoreException e) {
            throw logger.keyStoreConfigurationError((Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw logger.keyStoreProcessingError((Throwable)e);
        }
        catch (IOException e) {
            throw logger.keyStoreProcessingError((Throwable)e);
        }
    }

    @Override
    public PrivateKey getEncryptionKey() throws TrustKeyConfigurationException, TrustKeyProcessingException {
        if (StringUtil.isNullOrEmpty((String)this.encryptionAlias)) {
            return this.getSigningKey();
        }
        if (this.encryptionKeyPass == null || this.encryptionKeyPass.length == 0) {
            throw logger.keyStoreNullEncryptionKeyPass();
        }
        try {
            this.initKeyStore();
            return (PrivateKey)this.ks.getKey(this.encryptionAlias, this.encryptionKeyPass);
        }
        catch (KeyStoreException e) {
            throw logger.keyStoreConfigurationError((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw logger.keyStoreProcessingError((Throwable)e);
        }
        catch (UnrecoverableKeyException e) {
            throw logger.keyStoreProcessingError((Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw logger.keyStoreProcessingError((Throwable)e);
        }
        catch (IOException e) {
            throw logger.keyStoreProcessingError((Throwable)e);
        }
    }

    @Override
    public KeyPair getEncryptionKeyPair() throws TrustKeyConfigurationException, TrustKeyProcessingException {
        if (StringUtil.isNullOrEmpty((String)this.encryptionAlias)) {
            return this.getSigningKeyPair();
        }
        if (this.encryptionKeyPass == null || this.encryptionKeyPass.length == 0) {
            throw logger.keyStoreNullEncryptionKeyPass();
        }
        try {
            this.initKeyStore();
            PrivateKey privateKey = this.getSigningKey();
            PublicKey publicKey = KeyStoreUtil.getPublicKey(this.ks, this.encryptionAlias, this.encryptionKeyPass);
            return new KeyPair(publicKey, privateKey);
        }
        catch (KeyStoreException e) {
            throw logger.keyStoreConfigurationError((Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw logger.keyStoreProcessingError((Throwable)e);
        }
        catch (IOException e) {
            throw logger.keyStoreProcessingError((Throwable)e);
        }
    }

    @Override
    public Certificate getCertificate(String alias) throws TrustKeyConfigurationException, TrustKeyProcessingException {
        try {
            this.initKeyStore();
            if (alias == null || alias.length() == 0) {
                throw logger.keyStoreNullAlias();
            }
            return this.ks.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw logger.keyStoreConfigurationError((Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw logger.keyStoreProcessingError((Throwable)e);
        }
        catch (IOException e) {
            throw logger.keyStoreProcessingError((Throwable)e);
        }
    }

    @Override
    public PublicKey getPublicKey(String alias) throws TrustKeyConfigurationException, TrustKeyProcessingException {
        PublicKey publicKey = null;
        try {
            this.initKeyStore();
            Certificate cert = this.ks.getCertificate(alias);
            if (cert != null) {
                publicKey = cert.getPublicKey();
            } else {
                logger.keyStoreNullPublicKeyForAlias(alias);
            }
            return publicKey;
        }
        catch (KeyStoreException e) {
            throw logger.keyStoreConfigurationError((Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw logger.keyStoreProcessingError((Throwable)e);
        }
        catch (IOException e) {
            throw logger.keyStoreProcessingError((Throwable)e);
        }
    }

    @Override
    public PublicKey getValidatingKey(String domain) throws TrustKeyConfigurationException, TrustKeyProcessingException {
        PublicKey publicKey = null;
        try {
            this.initKeyStore();
            String domainAlias = this.domainAliasMap.get(domain);
            if (domainAlias == null && domain.startsWith("[") && domain.endsWith("]")) {
                domainAlias = this.domainAliasMap.get(domain.substring(1, domain.length() - 1));
            }
            if (domainAlias == null) {
                throw logger.keyStoreMissingDomainAlias(domain);
            }
            try {
                publicKey = KeyStoreUtil.getPublicKey(this.ks, domainAlias, this.keyStorePass.toCharArray());
            }
            catch (UnrecoverableKeyException urke) {
                if (this.signingKeyPass == null || this.signingKeyPass.length == 0) {
                    throw logger.keyStoreNullSigningKeyPass();
                }
                publicKey = KeyStoreUtil.getPublicKey(this.ks, domainAlias, this.signingKeyPass);
            }
        }
        catch (KeyStoreException e) {
            throw logger.keyStoreConfigurationError((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw logger.keyStoreProcessingError((Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw logger.keyStoreProcessingError((Throwable)e);
        }
        catch (IOException e) {
            throw logger.keyStoreProcessingError((Throwable)e);
        }
        return publicKey;
    }

    private void initKeyStore() throws GeneralSecurityException, IOException {
        if (this.ks == null) {
            logger.keyStoreSetup();
            this.setUpKeyStore();
        }
        if (this.ks == null) {
            throw logger.keyStoreNullStore();
        }
    }

    @Override
    public void setAuthProperties(List<AuthPropertyType> authList) throws TrustKeyConfigurationException, TrustKeyProcessingException {
        for (AuthPropertyType auth : authList) {
            this.authPropsMap.put(auth.getKey(), auth.getValue());
        }
        this.keyStoreURL = this.authPropsMap.get(KEYSTORE_URL);
        this.keyStorePass = this.authPropsMap.get(KEYSTORE_PASS);
        this.signingAlias = this.authPropsMap.get(SIGNING_KEY_ALIAS);
        String signKeypass = this.authPropsMap.get(SIGNING_KEY_PASS);
        if (signKeypass != null) {
            this.signingKeyPass = signKeypass.toCharArray();
        }
        this.encryptionAlias = this.authPropsMap.get(ENCRYPTION_KEY_ALIAS);
        String encKeypass = this.authPropsMap.get(ENCRYPTION_KEY_PASS);
        if (encKeypass != null) {
            this.encryptionKeyPass = encKeypass.toCharArray();
        }
    }

    @Override
    public void setValidatingAlias(List<KeyValueType> aliases) throws TrustKeyConfigurationException, TrustKeyProcessingException {
        for (KeyValueType alias : aliases) {
            this.domainAliasMap.put(alias.getKey(), alias.getValue());
        }
    }

    @Override
    public SecretKey getEncryptionKey(String domain, String encryptionAlgorithm, int keyLength) throws TrustKeyConfigurationException, TrustKeyProcessingException {
        SecretKey key = this.keys.get(domain);
        if (key == null) {
            try {
                key = EncryptionKeyUtil.getSecretKey(encryptionAlgorithm, keyLength);
            }
            catch (GeneralSecurityException e) {
                throw logger.keyStoreProcessingError((Throwable)e);
            }
            this.keys.put(domain, key);
        }
        return key;
    }

    @Override
    public void addAdditionalOption(String key, Object value) {
        this.options.put(key, value);
    }

    @Override
    public Object getAdditionalOption(String key) {
        return this.options.get(key);
    }

    private void setUpKeyStore() throws GeneralSecurityException, IOException {
        if (this.keyStoreURL == null) {
            this.keyStoreURL = SecurityActions.getProperty("javax.net.ssl.keyStore", null);
        }
        if (this.keyStorePass == null) {
            this.keyStorePass = SecurityActions.getProperty("javax.net.ssl.keyStorePassword", null);
        }
        InputStream is = this.getKeyStoreInputStream(this.keyStoreURL);
        this.ks = KeyStoreUtil.getKeyStore(is, this.keyStorePass.toCharArray());
    }

    private InputStream getKeyStoreInputStream(String keyStore) {
        String userHome;
        File ksDir;
        InputStream is;
        block10: {
            is = null;
            try {
                File file = new File(keyStore);
                is = new FileInputStream(file);
            }
            catch (Exception e) {
                URL url = null;
                try {
                    url = new URL(keyStore);
                    is = url.openStream();
                }
                catch (Exception ex) {
                    url = SecurityActions.loadResource(this.getClass(), keyStore);
                    if (url == null) break block10;
                    try {
                        is = url.openStream();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                }
            }
        }
        if (is == null && (ksDir = new File(userHome = SecurityActions.getSystemProperty("user.home", "") + "/jbid-keystore")).exists()) {
            try {
                is = new FileInputStream(new File(userHome + "/" + keyStore));
            }
            catch (FileNotFoundException e) {
                is = null;
            }
        }
        if (is == null) {
            throw logger.keyStoreNotLocated(keyStore);
        }
        return is;
    }
}

