/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v1.writers;

import java.net.URI;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.StaxUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.core.saml.v1.writers.BaseSAML11Writer;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11ActionType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AdviceType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AssertionType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AttributeStatementType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AttributeType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AudienceRestrictionCondition;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AuthenticationStatementType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AuthorityBindingType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AuthorizationDecisionStatementType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11ConditionAbstractType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11ConditionsType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11EvidenceType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11NameIdentifierType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11StatementAbstractType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11SubjectConfirmationType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11SubjectLocalityType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11SubjectStatementType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11SubjectType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.metadata.LocalizedNameType;
import org.w3c.dom.Element;

public class SAML11AssertionWriter
extends BaseSAML11Writer {
    String ns = "urn:oasis:names:tc:SAML:1.0:assertion";

    public SAML11AssertionWriter(XMLStreamWriter writer) {
        super(writer);
    }

    public void write(SAML11AssertionType assertion) throws ProcessingException {
        Element sig;
        SAML11AdviceType advice;
        SAML11ConditionsType conditions;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.ASSERTION.get(), (String)this.ns);
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)this.ns);
        StaxUtil.writeDefaultNameSpace((XMLStreamWriter)this.writer, (String)this.ns);
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"AssertionID", (String)assertion.getID());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"MajorVersion", (String)(assertion.getMajorVersion() + ""));
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"MinorVersion", (String)(assertion.getMinorVersion() + ""));
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.ISSUE_INSTANT.get(), (String)assertion.getIssueInstant().toString());
        String issuer = assertion.getIssuer();
        if (issuer != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"Issuer", (String)issuer);
        }
        if ((conditions = assertion.getConditions()) != null) {
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.CONDITIONS.get(), (String)this.ns);
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.NOT_BEFORE.get(), (String)conditions.getNotBefore().toString());
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.NOT_ON_OR_AFTER.get(), (String)conditions.getNotOnOrAfter().toString());
            List<SAML11ConditionAbstractType> typeOfConditions = conditions.get();
            if (typeOfConditions != null) {
                for (SAML11ConditionAbstractType typeCondition : typeOfConditions) {
                    if (!(typeCondition instanceof SAML11AudienceRestrictionCondition)) continue;
                    SAML11AudienceRestrictionCondition art = (SAML11AudienceRestrictionCondition)typeCondition;
                    StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)"AudienceRestrictionCondition", (String)this.ns);
                    List<URI> audiences = art.get();
                    if (audiences != null) {
                        for (URI audience : audiences) {
                            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.AUDIENCE.get(), (String)this.ns);
                            StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)audience.toString());
                            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
                        }
                    }
                    StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
                }
            }
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        if ((advice = assertion.getAdvice()) != null) {
            throw logger.notImplementedYet("Advice");
        }
        List<SAML11StatementAbstractType> statements = assertion.getStatements();
        if (statements != null) {
            for (SAML11StatementAbstractType statement : statements) {
                if (statement instanceof SAML11AuthenticationStatementType) {
                    this.write((SAML11AuthenticationStatementType)statement);
                    continue;
                }
                if (statement instanceof SAML11AttributeStatementType) {
                    this.write((SAML11AttributeStatementType)statement);
                    continue;
                }
                if (statement instanceof SAML11AuthorizationDecisionStatementType) {
                    this.write((SAML11AuthorizationDecisionStatementType)statement);
                    continue;
                }
                if (statement instanceof SAML11SubjectStatementType) {
                    this.write((SAML11SubjectStatementType)statement);
                    continue;
                }
                throw logger.writerUnknownTypeError(statement.getClass().getName());
            }
        }
        if ((sig = assertion.getSignature()) != null) {
            StaxUtil.writeDOMElement((XMLStreamWriter)this.writer, (Element)sig);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(StatementAbstractType statement) throws ProcessingException {
        throw logger.notImplementedYet("StatementAbstractType");
    }

    public void write(SAML11SubjectStatementType statement) throws ProcessingException {
        throw logger.notImplementedYet("SAML11SubjectStatementType");
    }

    public void write(SAML11AttributeStatementType statement) throws ProcessingException {
        List<SAML11AttributeType> attributes;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.ATTRIBUTE_STATEMENT.get(), (String)"urn:oasis:names:tc:SAML:1.0:assertion");
        SAML11SubjectType subject = statement.getSubject();
        if (subject != null) {
            this.write(subject);
        }
        if ((attributes = statement.get()) != null) {
            for (SAML11AttributeType attr : attributes) {
                this.write(attr);
            }
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(SAML11AuthenticationStatementType authnStatement) throws ProcessingException {
        SAML11SubjectLocalityType locality;
        SAML11SubjectType subject;
        URI authMethod;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)"AuthenticationStatement", (String)"urn:oasis:names:tc:SAML:1.0:assertion");
        XMLGregorianCalendar authnInstant = authnStatement.getAuthenticationInstant();
        if (authnInstant != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"AuthenticationInstant", (String)authnInstant.toString());
        }
        if ((authMethod = authnStatement.getAuthenticationMethod()) != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"AuthenticationMethod", (String)authMethod.toString());
        }
        if ((subject = authnStatement.getSubject()) != null) {
            this.write(subject);
        }
        if ((locality = authnStatement.getSubjectLocality()) != null) {
            this.write(locality);
        }
        List<SAML11AuthorityBindingType> authorities = authnStatement.getAuthorityBindingType();
        for (SAML11AuthorityBindingType authority : authorities) {
            this.write(authority);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(SAML11AuthorityBindingType authority) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)"AuthorityBinding", (String)"urn:oasis:names:tc:SAML:1.0:assertion");
        QName authorityKind = authority.getAuthorityKind();
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"AuthorityKind", (QName)authorityKind);
        String binding = authority.getBinding().toString();
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"Binding", (String)binding);
        String location = authority.getLocation().toString();
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"Location", (String)location);
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
    }

    public void write(SAML11SubjectLocalityType locality) throws ProcessingException {
        String dns;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.SUBJECT_LOCALITY.get(), (String)"urn:oasis:names:tc:SAML:1.0:assertion");
        String ip = locality.getIpAddress();
        if (StringUtil.isNotNull((String)ip)) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"IPAddress", (String)ip);
        }
        if (StringUtil.isNotNull((String)(dns = locality.getDnsAddress()))) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"DNSAddress", (String)dns);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
    }

    public void write(SAML11AuthorizationDecisionStatementType xacmlStat) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)"AuthorizationDecisionStatement", (String)this.ns);
        String resource = xacmlStat.getResource().toString();
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"Resource", (String)resource);
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"Decision", (String)xacmlStat.getDecision().name());
        SAML11SubjectType subject = xacmlStat.getSubject();
        if (subject != null) {
            this.write(subject);
        }
        List<SAML11ActionType> actions = xacmlStat.getActions();
        for (SAML11ActionType action : actions) {
            this.write(action);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(SAML11SubjectType subject) throws ProcessingException {
        SAML11SubjectConfirmationType confirmation;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.SUBJECT.get(), (String)"urn:oasis:names:tc:SAML:1.0:assertion");
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)this.ns);
        SAML11SubjectType.SAML11SubjectTypeChoice choice = subject.getChoice();
        if (choice != null) {
            SAML11SubjectConfirmationType confirmation2;
            SAML11NameIdentifierType nameid = choice.getNameID();
            if (nameid != null) {
                this.write(nameid);
            }
            if ((confirmation2 = choice.getSubjectConfirmation()) != null) {
                this.write(confirmation2);
            }
        }
        if ((confirmation = subject.getSubjectConfirmation()) != null) {
            this.write(confirmation);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(SAML11SubjectConfirmationType confirmation) throws ProcessingException {
        Object subjectConfirmationData;
        Element keyInfo;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.SUBJECT_CONFIRMATION.get(), (String)"urn:oasis:names:tc:SAML:1.0:assertion");
        List<URI> confirmationMethods = confirmation.getConfirmationMethod();
        if (confirmationMethods != null) {
            for (URI confirmationMethod : confirmationMethods) {
                StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)"ConfirmationMethod", (String)"urn:oasis:names:tc:SAML:1.0:assertion");
                StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)confirmationMethod.toString());
                StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
            }
        }
        if ((keyInfo = confirmation.getKeyInfo()) != null) {
            StaxUtil.writeDOMElement((XMLStreamWriter)this.writer, (Element)keyInfo);
        }
        if ((subjectConfirmationData = confirmation.getSubjectConfirmationData()) != null) {
            this.writeSubjectConfirmationData(subjectConfirmationData);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void writeSubjectConfirmationData(Object scData) throws ProcessingException {
        throw logger.notImplementedYet("SubjectConfirmationData");
    }

    public void write(SAML11NameIdentifierType nameid) throws ProcessingException {
        String nameQualifier;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)"NameIdentifier", (String)"urn:oasis:names:tc:SAML:1.0:assertion");
        URI format = nameid.getFormat();
        if (format != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"Format", (String)format.toString());
        }
        if (StringUtil.isNotNull((String)(nameQualifier = nameid.getNameQualifier()))) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"NameQualifier", (String)nameQualifier);
        }
        StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)nameid.getValue());
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(SAML11AttributeType attributeType) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.ATTRIBUTE.get(), (String)this.ns);
        this.writeAttributeTypeWithoutRootTag(attributeType);
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void writeAttributeTypeWithoutRootTag(SAML11AttributeType attributeType) throws ProcessingException {
        String attributeName = attributeType.getAttributeName();
        if (StringUtil.isNullOrEmpty((String)attributeName)) {
            throw logger.writerNullValueError("attribute name");
        }
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"AttributeName", (String)attributeName);
        String attributeNamespace = attributeType.getAttributeNamespace().toString();
        if (StringUtil.isNullOrEmpty((String)attributeNamespace)) {
            throw logger.writerNullValueError("attribute namespace");
        }
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"AttributeNamespace", (String)attributeNamespace);
        List<Object> attributeValues = attributeType.get();
        if (attributeValues != null) {
            for (Object attributeValue : attributeValues) {
                if (attributeValue instanceof String) {
                    this.writeStringAttributeValue((String)attributeValue);
                    continue;
                }
                throw logger.writerUnsupportedAttributeValueError(attributeValue.getClass().getName());
            }
        }
    }

    public void writeStringAttributeValue(String attributeValue) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.ATTRIBUTE_VALUE.get(), (String)this.ns);
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)JBossSAMLURIConstants.XSI_PREFIX.get(), (String)JBossSAMLURIConstants.XSI_NSURI.get());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)"xs", (String)JBossSAMLURIConstants.XMLSCHEMA_NSURI.get());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"xsi", (String)JBossSAMLURIConstants.XSI_NSURI.get(), (String)"type", (String)"xs:string");
        StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)attributeValue);
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
    }

    public void writeLocalizedNameType(LocalizedNameType localizedNameType, QName startElement) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)startElement.getPrefix(), (String)startElement.getLocalPart(), (String)startElement.getNamespaceURI());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (QName)new QName(JBossSAMLURIConstants.XML.get(), "lang", "xml"), (String)localizedNameType.getLang());
        StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)localizedNameType.getValue());
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
    }

    public void write(SAML11ActionType action) throws ProcessingException {
        String val;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)"Action", (String)this.ns);
        String ns = action.getNamespace();
        if (StringUtil.isNotNull((String)ns)) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"Namespace", (String)ns);
        }
        if (StringUtil.isNotNull((String)(val = action.getValue()))) {
            StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)val);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
    }

    public void write(SAML11EvidenceType evidence) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)"Evidence", (String)this.ns);
        List<String> assertionIDRefs = evidence.getAssertionIDReference();
        for (String assertionIDRef : assertionIDRefs) {
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)"AssertionIDReference", (String)this.ns);
            StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)assertionIDRef);
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        List<SAML11AssertionType> assertions = evidence.getAssertions();
        for (SAML11AssertionType assertion : assertions) {
            this.write(assertion);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
    }
}

