/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.core.saml.v2.constants.X500SAMLProfileConstants;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnContextClassRefType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnContextType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;

public class StatementUtil {
    public static final QName X500_QNAME = new QName(JBossSAMLURIConstants.X500_NSURI.get(), "Encoding", JBossSAMLURIConstants.X500_PREFIX.get());

    public static AuthnStatementType createAuthnStatement(XMLGregorianCalendar instant, String authnContextClassRefValue) {
        AuthnStatementType authnStatement = new AuthnStatementType(instant);
        AuthnContextType authnContext = new AuthnContextType();
        AuthnContextClassRefType authnContextClassRef = new AuthnContextClassRefType(URI.create(authnContextClassRefValue));
        AuthnContextType.AuthnContextTypeSequence sequence = authnContext.new AuthnContextType.AuthnContextTypeSequence();
        sequence.setClassRef(authnContextClassRef);
        authnContext.setSequence(sequence);
        authnStatement.setAuthnContext(authnContext);
        return authnStatement;
    }

    public static AttributeStatementType createAttributeStatement(Map<String, Object> attributes) {
        AttributeStatementType attrStatement = null;
        int i = 0;
        Set<String> keys = attributes.keySet();
        for (String key : keys) {
            AttributeType att;
            if (i == 0) {
                attrStatement = new AttributeStatementType();
                ++i;
            }
            if ("roles".equalsIgnoreCase(key)) {
                Object value = attributes.get(key);
                if (!(value instanceof Collection)) continue;
                Collection roles = (Collection)value;
                attrStatement = StatementUtil.createAttributeStatement(new ArrayList<String>(roles));
                continue;
            }
            Object value = attributes.get(key);
            String uri = X500SAMLProfileConstants.getOID(key);
            if (StringUtil.isNotNull((String)uri)) {
                att = StatementUtil.getX500Attribute(uri);
                att.setFriendlyName(key);
            } else {
                att = new AttributeType(key);
                att.setFriendlyName(key);
                att.setNameFormat(JBossSAMLURIConstants.ATTRIBUTE_FORMAT_URI.get());
            }
            if (Collection.class.isInstance(value)) {
                Collection collection = (Collection)value;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    att.addAttributeValue(iterator.next());
                }
            } else if (String.class.isInstance(value)) {
                att.addAttributeValue(value);
            } else {
                throw new RuntimeException("Unsupported attribute value [" + value + "]. Values must be a string, even if using a Collection.");
            }
            attrStatement.addAttribute(new AttributeStatementType.ASTChoiceType(att));
        }
        return attrStatement;
    }

    public static AttributeStatementType createAttributeStatement(List<String> roles) {
        AttributeStatementType attrStatement = null;
        for (String role : roles) {
            if (attrStatement == null) {
                attrStatement = new AttributeStatementType();
            }
            AttributeType attr = new AttributeType("Role");
            attr.addAttributeValue(role);
            attrStatement.addAttribute(new AttributeStatementType.ASTChoiceType(attr));
        }
        return attrStatement;
    }

    public static AttributeStatementType createAttributeStatementForRoles(List<String> roles, boolean multivalued) {
        if (!multivalued) {
            return StatementUtil.createAttributeStatement(roles);
        }
        AttributeStatementType attrStatement = new AttributeStatementType();
        AttributeType attr = new AttributeType("Role");
        for (String role : roles) {
            attr.addAttributeValue(role);
        }
        attrStatement.addAttribute(new AttributeStatementType.ASTChoiceType(attr));
        return attrStatement;
    }

    public static AttributeStatementType createAttributeStatement(String key, String value) {
        AttributeStatementType attrStatement = new AttributeStatementType();
        AttributeType attr = new AttributeType(key);
        attr.addAttributeValue(value);
        attrStatement.addAttribute(new AttributeStatementType.ASTChoiceType(attr));
        return attrStatement;
    }

    public static Map<String, Object> asMap(Set<AttributeStatementType> attributeStatementTypes) {
        HashMap<String, Object> attrMap = new HashMap<String, Object>();
        if (attributeStatementTypes != null && !attributeStatementTypes.isEmpty()) {
            attrMap = new HashMap();
            for (StatementAbstractType statementAbstractType : attributeStatementTypes) {
                if (!(statementAbstractType instanceof AttributeStatementType)) continue;
                AttributeStatementType attrStat = (AttributeStatementType)statementAbstractType;
                List<AttributeStatementType.ASTChoiceType> attrs = attrStat.getAttributes();
                for (AttributeStatementType.ASTChoiceType attrChoice : attrs) {
                    List<Object> values;
                    AttributeType attr = attrChoice.getAttribute();
                    String attributeName = attr.getFriendlyName();
                    if (attributeName == null) {
                        attributeName = attr.getName();
                    }
                    if ((values = attr.getAttributeValue()) == null) continue;
                    if (values.size() == 1) {
                        attrMap.put(attributeName, values.get(0));
                        continue;
                    }
                    attrMap.put(attributeName, values);
                }
            }
        }
        return attrMap;
    }

    private static AttributeType getX500Attribute(String name) {
        AttributeType att = new AttributeType(name);
        att.getOtherAttributes().put(X500_QNAME, "LDAP");
        att.setNameFormat(JBossSAMLURIConstants.ATTRIBUTE_FORMAT_URI.get());
        return att;
    }
}

