/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.io.IOExtension;
import org.wildfly.extension.io.OptionAttributeDefinition;
import org.wildfly.extension.io.WorkerAdd;
import org.xnio.Options;
import org.xnio.XnioWorker;

class WorkerResourceDefinition
extends PersistentResourceDefinition {
    static final String IO_WORKER_RUNTIME_CAPABILITY_NAME = "org.wildfly.io.worker";
    static final RuntimeCapability<Void> IO_WORKER_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.io.worker", (boolean)true, XnioWorker.class).build();
    static final OptionAttributeDefinition WORKER_TASK_CORE_THREADS = ((OptionAttributeDefinition.Builder)new OptionAttributeDefinition.Builder("task-core-threads", Options.WORKER_TASK_CORE_THREADS).setDefaultValue(new ModelNode(2))).build();
    static final OptionAttributeDefinition WORKER_TASK_MAX_THREADS = new OptionAttributeDefinition.Builder("task-max-threads", Options.WORKER_TASK_MAX_THREADS).build();
    static final OptionAttributeDefinition WORKER_TASK_KEEPALIVE = ((OptionAttributeDefinition.Builder)new OptionAttributeDefinition.Builder("task-keepalive", Options.WORKER_TASK_KEEPALIVE).setDefaultValue(new ModelNode(60))).build();
    static final OptionAttributeDefinition STACK_SIZE = ((OptionAttributeDefinition.Builder)new OptionAttributeDefinition.Builder("stack-size", Options.STACK_SIZE).setDefaultValue(new ModelNode(0L))).build();
    static final OptionAttributeDefinition WORKER_IO_THREADS = new OptionAttributeDefinition.Builder("io-threads", Options.WORKER_IO_THREADS).build();
    static OptionAttributeDefinition[] ATTRIBUTES = new OptionAttributeDefinition[]{WORKER_IO_THREADS, WORKER_TASK_CORE_THREADS, WORKER_TASK_KEEPALIVE, WORKER_TASK_MAX_THREADS, STACK_SIZE};
    static final Map<String, OptionAttributeDefinition> ATTRIBUTES_BY_XMLNAME;
    static final WorkerResourceDefinition INSTANCE;

    private WorkerResourceDefinition() {
        super(IOExtension.WORKER_PATH, (ResourceDescriptionResolver)IOExtension.getResolver("worker"), (OperationStepHandler)WorkerAdd.INSTANCE, (OperationStepHandler)new ReloadRequiredRemoveStepHandler(new RuntimeCapability[]{IO_WORKER_RUNTIME_CAPABILITY}));
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES_BY_XMLNAME.values();
    }

    static {
        HashMap<String, OptionAttributeDefinition> attrs = new HashMap<String, OptionAttributeDefinition>();
        for (OptionAttributeDefinition attr : ATTRIBUTES) {
            attrs.put(attr.getXmlName(), attr);
        }
        ATTRIBUTES_BY_XMLNAME = Collections.unmodifiableMap(attrs);
        INSTANCE = new WorkerResourceDefinition();
    }
}

