/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.affinity.impl.KeyAffinityServiceImpl;
import org.infinispan.remoting.transport.Address;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.clustering.infinispan.spi.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.infinispan.spi.service.CacheContainerServiceName;
import org.wildfly.clustering.service.AsynchronousServiceBuilder;
import org.wildfly.clustering.service.Builder;

public class KeyAffinityServiceFactoryBuilder
implements Builder<KeyAffinityServiceFactory>,
Service<KeyAffinityServiceFactory>,
KeyAffinityServiceFactory {
    private final String containerName;
    private volatile int bufferSize = 10;
    private volatile ExecutorService executor;

    public KeyAffinityServiceFactoryBuilder(String containerName) {
        this.containerName = containerName;
    }

    public KeyAffinityServiceFactoryBuilder bufferSize(int size) {
        this.bufferSize = size;
        return this;
    }

    public ServiceName getServiceName() {
        return CacheContainerServiceName.AFFINITY.getServiceName(this.containerName);
    }

    public ServiceBuilder<KeyAffinityServiceFactory> build(ServiceTarget target) {
        return new AsynchronousServiceBuilder(this.getServiceName(), (Service)this).startSynchronously().build(target).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public KeyAffinityServiceFactory getValue() {
        return this;
    }

    public void start(StartContext context) {
        final ThreadGroup threadGroup = new ThreadGroup("KeyAffinityService ThreadGroup");
        String namePattern = "KeyAffinityService Thread Pool -- %t";
        ThreadFactory threadFactory = (ThreadFactory)AccessController.doPrivileged(new PrivilegedAction<JBossThreadFactory>(){

            @Override
            public JBossThreadFactory run() {
                return new JBossThreadFactory(threadGroup, Boolean.FALSE, null, "KeyAffinityService Thread Pool -- %t", null, null);
            }
        });
        this.executor = Executors.newCachedThreadPool(threadFactory);
    }

    public void stop(StopContext context) {
        this.executor.shutdown();
    }

    public <K> KeyAffinityService<K> createService(Cache<K, ?> cache, KeyGenerator<K> generator) {
        boolean clustered = cache.getCacheConfiguration().clustering().cacheMode().isClustered();
        return clustered ? new KeyAffinityServiceImpl((Executor)this.executor, cache, generator, this.bufferSize, Collections.singleton(cache.getCacheManager().getAddress()), false) : new SimpleKeyAffinityService<K>(generator);
    }

    private static class SimpleKeyAffinityService<K>
    implements KeyAffinityService<K> {
        private final KeyGenerator<K> generator;
        private volatile boolean started = false;

        SimpleKeyAffinityService(KeyGenerator<K> generator) {
            this.generator = generator;
        }

        public void start() {
            this.started = true;
        }

        public void stop() {
            this.started = false;
        }

        public K getKeyForAddress(Address address) {
            return (K)this.generator.getKey();
        }

        public K getCollocatedKey(K otherKey) {
            return (K)this.generator.getKey();
        }

        public boolean isStarted() {
            return this.started;
        }
    }
}

