/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.wildfly.providers;

import java.io.IOException;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.identity.federation.bindings.wildfly.providers.OAuthProtocolContext;
import org.picketlink.identity.federation.core.interfaces.ProtocolContext;
import org.picketlink.identity.federation.core.interfaces.SecurityTokenProvider;
import org.picketlink.identity.federation.core.sts.AbstractSecurityTokenProvider;
import org.picketlink.identity.federation.core.sts.PicketLinkCoreSTS;

public class OAuth2TokenProvider
extends AbstractSecurityTokenProvider
implements SecurityTokenProvider {
    public boolean supports(String namespace) {
        return "urn:oauth:2:0".equals(namespace);
    }

    public String tokenType() {
        return "urn:oauth:2:0";
    }

    public QName getSupportedQName() {
        return new QName("urn:oauth:2:0");
    }

    public String family() {
        return SecurityTokenProvider.FAMILY_TYPE.OAUTH.name();
    }

    public void issueToken(ProtocolContext context) throws ProcessingException {
        if (!(context instanceof OAuthProtocolContext)) {
            return;
        }
        OAuthProtocolContext oAuthProtocolContext = (OAuthProtocolContext)context;
        String samlAssertionID = oAuthProtocolContext.getSamlAssertionID();
        this.check();
        String generatedToken = UUID.randomUUID().toString();
        oAuthProtocolContext.setToken(generatedToken);
        try {
            this.tokenRegistry.addToken(samlAssertionID, (Object)generatedToken);
        }
        catch (IOException e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    public void renewToken(ProtocolContext context) throws ProcessingException {
        if (!(context instanceof OAuthProtocolContext)) {
            return;
        }
        this.check();
    }

    public void cancelToken(ProtocolContext context) throws ProcessingException {
        if (!(context instanceof OAuthProtocolContext)) {
            return;
        }
        OAuthProtocolContext oAuthProtocolContext = (OAuthProtocolContext)context;
        String samlAssertionID = oAuthProtocolContext.getSamlAssertionID();
        this.check();
        try {
            this.tokenRegistry.removeToken(samlAssertionID);
        }
        catch (IOException e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    public void validateToken(ProtocolContext context) throws ProcessingException {
        if (!(context instanceof OAuthProtocolContext)) {
            return;
        }
        OAuthProtocolContext oAuthProtocolContext = (OAuthProtocolContext)context;
        String samlAssertionID = oAuthProtocolContext.getSamlAssertionID();
        this.check();
        String oauthToken = (String)this.tokenRegistry.getToken(samlAssertionID);
        if (oauthToken == null) {
            throw new ProcessingException("Not Valid");
        }
    }

    protected void check() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PicketLinkCoreSTS.rte);
        }
    }
}

