/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.interception;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NoContentException;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.ReaderInterceptor;
import org.jboss.resteasy.core.interception.AbstractReaderInterceptorContext;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ServerReaderInterceptorContext
extends AbstractReaderInterceptorContext {
    private static final Logger logger = Logger.getLogger(ServerReaderInterceptorContext.class);
    private HttpRequest request;

    public ServerReaderInterceptorContext(ReaderInterceptor[] interceptors, ResteasyProviderFactory providerFactory, Class type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream inputStream, HttpRequest request) {
        super(mediaType, providerFactory, annotations, interceptors, headers, genericType, type, inputStream);
        this.request = request;
    }

    @Override
    protected MessageBodyReader resolveReader(MediaType mediaType) {
        MessageBodyReader reader = this.providerFactory.getServerMessageBodyReader(this.type, this.genericType, this.annotations, mediaType);
        return reader;
    }

    @Override
    protected void throwReaderNotFound() {
        throw new NotSupportedException("Could not find message body reader for type: " + this.genericType + " of content type: " + this.mediaType);
    }

    @Override
    protected Object readFrom(MessageBodyReader reader) throws IOException {
        try {
            return super.readFrom(reader);
        }
        catch (NoContentException e) {
            throw new BadRequestException((Throwable)e);
        }
    }

    public Object getProperty(String name) {
        return this.request.getAttribute(name);
    }

    public Collection<String> getPropertyNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration<String> enames = this.request.getAttributeNames();
        while (enames.hasMoreElements()) {
            names.add(enames.nextElement());
        }
        return names;
    }

    public void setProperty(String name, Object object) {
        if (object == null) {
            this.request.removeAttribute(name);
        } else {
            this.request.setAttribute(name, object);
        }
    }

    public void removeProperty(String name) {
        this.request.removeAttribute(name);
    }
}

