/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.weld.WeldProvider;
import org.jboss.as.weld.deployment.BeanDeploymentArchiveImpl;
import org.jboss.as.weld.deployment.WeldDeployment;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.as.weld.services.ModuleGroupSingletonProvider;
import org.jboss.as.weld.services.bootstrap.WeldSecurityServices;
import org.jboss.as.weld.services.bootstrap.WeldTransactionServices;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.weld.Container;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.ExecutorServices;
import org.jboss.weld.security.spi.SecurityServices;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WeldBootstrapService
implements Service<WeldBootstrapService> {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"WeldBootstrapService"});
    private final WeldBootstrap bootstrap;
    private final WeldDeployment deployment;
    private final Environment environment;
    private final Map<String, BeanDeploymentArchive> beanDeploymentArchives;
    private final BeanDeploymentArchiveImpl rootBeanDeploymentArchive;
    private final String deploymentName;
    private final InjectedValue<WeldSecurityServices> securityServices = new InjectedValue();
    private final InjectedValue<WeldTransactionServices> weldTransactionServices = new InjectedValue();
    private final InjectedValue<ExecutorServices> executorServices = new InjectedValue();
    private volatile boolean started;

    public WeldBootstrapService(WeldDeployment deployment, Environment environment, String deploymentName) {
        this.deployment = deployment;
        this.environment = environment;
        this.deploymentName = deploymentName;
        this.bootstrap = new WeldBootstrap();
        HashMap<String, BeanDeploymentArchive> bdas = new HashMap<String, BeanDeploymentArchive>();
        BeanDeploymentArchiveImpl rootBeanDeploymentArchive = null;
        for (BeanDeploymentArchive archive : deployment.getBeanDeploymentArchives()) {
            BeanDeploymentArchiveImpl bda;
            bdas.put(archive.getId(), archive);
            if (!(archive instanceof BeanDeploymentArchiveImpl) || !(bda = (BeanDeploymentArchiveImpl)archive).isRoot()) continue;
            rootBeanDeploymentArchive = bda;
        }
        this.rootBeanDeploymentArchive = rootBeanDeploymentArchive;
        this.beanDeploymentArchives = Collections.unmodifiableMap(bdas);
    }

    public synchronized void start(StartContext context) {
        if (this.started) {
            throw WeldLogger.ROOT_LOGGER.alreadyRunning("WeldContainer");
        }
        this.started = true;
        WeldLogger.DEPLOYMENT_LOGGER.startingWeldService(this.deploymentName);
        this.addWeldService(SecurityServices.class, (org.jboss.weld.bootstrap.api.Service)this.securityServices.getValue());
        this.addWeldService(TransactionServices.class, (org.jboss.weld.bootstrap.api.Service)this.weldTransactionServices.getValue());
        if (!this.deployment.getServices().contains(ExecutorServices.class)) {
            this.addWeldService(ExecutorServices.class, (org.jboss.weld.bootstrap.api.Service)this.executorServices.getValue());
        }
        ModuleGroupSingletonProvider.addClassLoaders((ClassLoader)this.deployment.getModule().getClassLoader(), this.deployment.getSubDeploymentClassLoaders());
        ClassLoader oldTccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.deployment.getModule().getClassLoader());
            this.bootstrap.startContainer(this.deploymentName, this.environment, (Deployment)this.deployment);
            WeldProvider.containerInitialized(Container.instance((String)this.deploymentName), this.getBeanManager(), this.deployment);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
        }
    }

    public synchronized void stop(StopContext context) {
        if (!this.started) {
            throw WeldLogger.ROOT_LOGGER.notStarted("WeldContainer");
        }
        WeldLogger.DEPLOYMENT_LOGGER.stoppingWeldService(this.deploymentName);
        ClassLoader oldTccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.deployment.getModule().getClassLoader());
            WeldProvider.containerShutDown(Container.instance((String)this.deploymentName));
            this.bootstrap.shutdown();
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
            ModuleGroupSingletonProvider.removeClassLoader((ClassLoader)this.deployment.getModule().getClassLoader());
        }
        this.started = false;
    }

    public BeanManagerImpl getBeanManager(String beanArchiveId) {
        if (!this.started) {
            throw WeldLogger.ROOT_LOGGER.notStarted("WeldContainer");
        }
        BeanDeploymentArchive beanDeploymentArchive = this.beanDeploymentArchives.get(beanArchiveId);
        if (beanDeploymentArchive == null) {
            throw WeldLogger.ROOT_LOGGER.beanDeploymentNotFound(beanArchiveId);
        }
        return this.bootstrap.getManager(beanDeploymentArchive);
    }

    public <T extends org.jboss.weld.bootstrap.api.Service> void addWeldService(Class<T> type, T service) {
        this.deployment.addWeldService(type, service);
    }

    public BeanManagerImpl getBeanManager() {
        if (!this.started) {
            throw WeldLogger.ROOT_LOGGER.notStarted("WeldContainer");
        }
        return this.bootstrap.getManager((BeanDeploymentArchive)this.rootBeanDeploymentArchive);
    }

    public Set<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return new HashSet<BeanDeploymentArchive>(this.beanDeploymentArchives.values());
    }

    public boolean isStarted() {
        return this.started;
    }

    WeldBootstrap getBootstrap() {
        return this.bootstrap;
    }

    public WeldBootstrapService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<WeldSecurityServices> getSecurityServices() {
        return this.securityServices;
    }

    public InjectedValue<WeldTransactionServices> getWeldTransactionServices() {
        return this.weldTransactionServices;
    }

    public InjectedValue<ExecutorServices> getExecutorServices() {
        return this.executorServices;
    }
}

