/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jgroups.Channel;
import org.wildfly.clustering.jgroups.spi.RemoteSiteConfiguration;
import org.wildfly.clustering.jgroups.spi.service.ChannelServiceName;
import org.wildfly.clustering.jgroups.spi.service.ProtocolStackServiceName;
import org.wildfly.clustering.service.Builder;

public class RemoteSiteConfigurationBuilder
implements Builder<RemoteSiteConfiguration>,
Value<RemoteSiteConfiguration>,
RemoteSiteConfiguration {
    private final InjectedValue<Channel> channel = new InjectedValue();
    private final String stackName;
    private final String siteName;
    private String channelName;

    public RemoteSiteConfigurationBuilder(String stackName, String siteName) {
        this.stackName = stackName;
        this.siteName = siteName;
    }

    public ServiceName getServiceName() {
        return ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(this.stackName).append(new String[]{"relay", this.siteName});
    }

    public ServiceBuilder<RemoteSiteConfiguration> build(ServiceTarget target) {
        return target.addService(this.getServiceName(), (Service)new ValueService((Value)this)).addDependency(ChannelServiceName.CHANNEL.getServiceName(this.channelName), Channel.class, this.channel).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public RemoteSiteConfiguration getValue() {
        return this;
    }

    public RemoteSiteConfigurationBuilder setChannel(String channelName) {
        this.channelName = channelName;
        return this;
    }

    public String getName() {
        return this.siteName;
    }

    public Channel getChannel() {
        return (Channel)this.channel.getValue();
    }

    public String getClusterName() {
        return this.channelName;
    }
}

